/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class Palindrome
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w w^R : w element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>ww<sup>R</sup></i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>bba<sup><i>m</i></sup>\".  The <i>y</i> value thus would be a multiple of \"a\" in 'w' and not in 'w<sup>R</sup>'.  If <i>i</i> = 0, then the total string becomes at most \"a<sup><i>m</i>-1</sup>bba<sup><i>m</i></sup>\", which is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(Palindrome.pumpString("a", this.m)) + "bb" + Palindrome.pumpString("a", this.m);
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{Math.min(this.w.length() / 2 - 1, this.m - 2), 2});
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 10};
    }

    @Override
    public boolean isInLang(String s) {
        int size = s.length();
        if (size == 0) {
            return true;
        }
        if (size % 2 == 1) {
            return false;
        }
        int halfSize = size / 2;
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        int i = 0;
        while (i <= halfSize) {
            if (s.charAt(i) != s.charAt(size - i - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

