/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.RegularPumpingLemma;

public class BkABnBAn
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getHTMLTitle() {
        return "<i>b<sup>k</sup>(ab)<sup>n</sup>(ba)<sup>n</sup></i> : <i>k</i> " + GREATER_OR_EQ + " 4" + ", <i>n</i> = 1,2...";
    }

    @Override
    public String getTitle() {
        return "b^k (ab)^n (ba)^n: k>=4, n = 1,2,...";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"b<sup>4</sup>(ab)<sup><i>m</i>/2</sup>(ba)<sup><i>m</i>/2</sup>\".  No possible <i>y</i> value among the \"b<sup>4</sup>(ab)<sup><i>m</i>/2</sup>\" segment will work, so the language is not regular.";
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    public void chooseDecomposition() {
        int a = this.w.indexOf(97);
        int abba = a + (this.w.length() - a) / 2 - 2;
        if (a > 4) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else if (abba + 4 <= this.m) {
            this.setDecomposition(new int[]{abba, 4});
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    protected void chooseW() {
        int power = this.m / 2;
        this.w = "bbbb" + BkABnBAn.pumpString("ab", power) + BkABnBAn.pumpString("ba", power);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{4, 15};
    }

    @Override
    public boolean isInLang(String s) {
        int k = s.indexOf("a");
        if (k < 4) {
            return false;
        }
        String temp = s.substring(k);
        if (!temp.startsWith("ab")) {
            return false;
        }
        int n = 0;
        while (temp.startsWith("ab")) {
            temp = temp.substring(2);
            ++n;
        }
        while (temp.startsWith("ba")) {
            temp = temp.substring(2);
            --n;
        }
        return n == 0 && temp.length() == 0;
    }
}

