/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class B5Wmod
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "b^5w: w element_of {ab}* : (2na(w) + 5nb(w)) % 3 = 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>b<sup>5</sup>w</i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR + ", (2<i>n<sub>a</sub></i> (<i>w</i>) + " + " 5<i>n<sub>b</sub></i> (<i>w</i>)) mod 3 = 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 8, " + "as long as |<i>y</i>| % 3 = 0 and none of the first 5 \"b\"s are in <i>y</i>, the decomposition is " + "successful.  Pumping any possible combination of 3 characters yields a string divisible by 3.";
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void chooseW() {
        this.w = "bbbbb";
        int i = 5;
        while (i < this.m || (i - 5) % 3 != 0) {
            this.w = LemmaMath.flipCoin() == 2 ? String.valueOf(this.w) + 'a' : String.valueOf(this.w) + 'b';
            ++i;
        }
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{5, 3});
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{8, 20};
    }

    @Override
    public boolean isInLang(String s) {
        int b;
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        if (!s.startsWith("bbbbb")) {
            return false;
        }
        String temp = s.substring(5);
        int a = LemmaMath.countInstances(temp, 'a');
        return (2 * a + 5 * (b = LemmaMath.countInstances(temp, 'b'))) % 3 == 0;
    }
}

