/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBlAk
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^n b^l a^k : n > 5, l > 3, k <= l";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>l</sup>a<sup>k</sup></i> : <i>n</i> " + GREATER_THAN + " 5, <i>l</i> " + GREATER_THAN + " 3, <i>k</i> " + LESS_OR_EQ + " <i>l</i>";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value " + GREATER_OR_EQ + " 4, a possible value for <i>w</i> is \"a<sup>6</sup>" + "b<sup><i>m</i></sup>a<sup><i>m</i></sup>\".  The <i>y</i> value thus would be a combination of \"a\"s " + "and \"b\"s, in that order.  If <i>i</i> = 0, either n " + LESS_OR_EQ + " 5, k > l, or both, giving a " + "string that is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = this.getM() <= 3 ? String.valueOf(AnBlAk.pumpString("a", 6)) + AnBlAk.pumpString("b", 4) + AnBlAk.pumpString("a", 4) : String.valueOf(AnBlAk.pumpString("a", 6)) + AnBlAk.pumpString("b", this.getM()) + AnBlAk.pumpString("a", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int b = this.w.indexOf(98);
        if (b > 6) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else {
            this.setDecomposition(new int[]{Math.min(b, this.m - 1), 1});
        }
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 15};
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b', 'a'};
        if (LemmaMath.isMixture(s, list)) {
            return false;
        }
        int b = LemmaMath.countInstances(s, 'b');
        if (b == 0) {
            return false;
        }
        String ba2 = s.substring(s.indexOf(98));
        int a = s.length() - ba2.length();
        int a2 = LemmaMath.countInstances(ba2, 'a');
        return a > 5 && b > 3 && a2 <= b;
    }
}

