/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBk
extends RegularPumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^n b^k : n is odd or k is even";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>k</sup></i> : <i>n</i> is odd or <i>k</i> is even.";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 3, a <i>y</i> value of \"aa\" or \"bb\" will always pump the string.  At least one of those substrings " + "can be the <i>y</i> value.";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 10};
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void chooseW() {
        this.w = this.m % 2 == 0 ? String.valueOf(AnBk.pumpString("a", this.m - 2)) + "bb" : "a" + AnBk.pumpString("b", this.m);
    }

    @Override
    public void chooseDecomposition() {
        int firstB = this.w.indexOf(98);
        if (firstB == -1 || firstB >= 2) {
            int[] nArray = new int[2];
            nArray[1] = 2;
            this.setDecomposition(nArray);
        } else {
            this.setDecomposition(new int[]{firstB, 2});
        }
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.isMixture(s, list)) {
            return false;
        }
        int a = LemmaMath.countInstances(s, 'a');
        int b = LemmaMath.countInstances(s, 'b');
        return a % 2 == 1 || b % 2 == 0;
    }
}

