/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1VVrW2
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w1 v v^R w2 : na(w1) = na(w2), |v|>=3, w1 & w2 element_of {ab}*";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>vv<sup>R</sup>w<sub>2</sub></i>, : <i>n<sub>a</sub></i>(<i>w<sub>1</sub></i>) = <i>n<sub>a</sub></i>(<i>w<sub>2</sub></i>),  |<i>v</i>| " + GREATER_THAN + " 3,  <i>v</i>, <i>w<sub>1</sub>, " + "w<sub>2</sub> " + ELEMENT_OF + " " + AB_STAR;
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  If |'v'| " + GREATER_THAN + " 3, " + "or if <i>m</i> " + GREATER_OR_EQ + " 8 and there are no \"b\"s in w<sub>1</sub> and w<sub>2</sub>, one could " + "just pump single opposite characters in 'v' and 'v<sup>R</sup>' repeatedly to find a valid decomposition.  " + "For example, if |'v'| = 4, then <i>v</i> could equal the fourth character of 'v' and <i>y</i> the first " + "character of 'v<sup>R</sup>'.  Otherwise, if <i>m</i> " + GREATER_OR_EQ + " 8 and |v| = 3, one could just " + "pump the first \"b\" value in w<sub>1</sub> or w<sub>2</sub>.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    public void chooseI() {
        this.i = 3;
    }

    @Override
    protected void chooseW() {
        int power = this.m / 2;
        this.w = String.valueOf(W1VVrW2.pumpString("ab", power)) + "abbbba" + W1VVrW2.pumpString("ab", power);
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 15};
    }

    private int[] getVVr(String s) {
        if (s.length() < 6) {
            return null;
        }
        int end = s.length() - 1;
        while (end >= 5) {
            int start = 0;
            while (start <= end - 5) {
                if ((end - start) % 2 == 1 && s.charAt(start) == s.charAt(end)) {
                    boolean match = true;
                    int i = 0;
                    while (i <= (end - start) / 2) {
                        if (s.charAt(start + i) != s.charAt(end - i)) {
                            match = false;
                        }
                        ++i;
                    }
                    if (match && LemmaMath.countInstances(s.substring(0, start), 'a') == LemmaMath.countInstances(s.substring(end + 1), 'a')) {
                        return new int[]{start, end};
                    }
                }
                ++start;
            }
            --end;
        }
        return null;
    }

    @Override
    public void chooseDecomposition() {
        int[] v = this.getVVr(this.w);
        String w1 = this.w.substring(0, v[0]);
        String w2 = this.w.substring(v[1] + 1);
        if (v[1] - v[0] > 5 || LemmaMath.countInstances(w1, 'b') == 0 && LemmaMath.countInstances(w2, 'b') == 0) {
            int[] nArray = new int[4];
            nArray[0] = v[0] + (v[1] - v[0]) / 2;
            nArray[1] = 1;
            nArray[3] = 1;
            this.setDecomposition(nArray);
        } else if (w1.indexOf(98) > -1) {
            int[] nArray = new int[4];
            nArray[0] = w1.indexOf(98);
            nArray[1] = 1;
            this.setDecomposition(nArray);
        } else {
            int[] nArray = new int[4];
            nArray[0] = w2.indexOf(98) + v[1] + 1;
            nArray[1] = 1;
            this.setDecomposition(nArray);
        }
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(s, list)) {
            return false;
        }
        return this.getVVr(s) != null;
    }
}

