/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class W1CW2CW3CW4
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "w1cw2cw3cw4 : w1 = w2 or w3 = w4, wi element_of {ab}*, |wi| >= 5";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>w<sub>1</sub>cw<sub>2</sub>cw<sub>3</sub>cw<sub>4</sub></i>, : <i>w<sub>1</sub></i> = <i>w<sub>2</sub></i> or <i>w<sub>3</sub></i> = <i>w<sub>4</sub></i>, <i>w<sub>i</sub></i> " + ELEMENT_OF + " " + AB_STAR + ", |<i>w<sub>i</sub></i>| > 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>ca<sup><i>m</i></sup>b<sup><i>m</i></sup>cacb\".  If either <i>v</i> or <i>y</i> together span two 'w<sub>n</sub>'s or span less but possess a \"c\", then pumping that value could result in more or less than three \"c\"s, which is not permissible.  If either <i>v</i> or <i>y</i> span 'w<sub>3</sub>' or 'w<sub>4</sub>', then if <i>i</i> = 0, |'w<sub>3</sub>'| = 0 or |'w<sub>4</sub>'| = 0.  If either <i>v</i> or <i>y</i> span 'w<sub>1</sub>' or 'w<sub>2</sub>', then for any <i>i</i> " + NOT_EQUAL + " 1, 'w<sub>1</sub>' " + NOT_EQUAL + " 'w<sub>2</sub>'.  Thus, this language is not context-free.";
    }

    @Override
    protected void addCases() {
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(W1CW2CW3CW4.pumpString("a", this.m)) + W1CW2CW3CW4.pumpString("b", this.m) + 'c' + W1CW2CW3CW4.pumpString("a", this.m) + W1CW2CW3CW4.pumpString("b", this.m) + "cacb";
    }

    @Override
    public void chooseDecomposition() {
        String[] wArray = this.getWs(this.w);
        int[] decomp = this.checkIfPossibility(wArray[0], wArray[1], 0);
        if (decomp != null) {
            this.setDecomposition(decomp);
            return;
        }
        decomp = this.checkIfPossibility(wArray[2], wArray[3], wArray[0].length() + wArray[1].length() + 2);
        if (decomp != null) {
            this.setDecomposition(decomp);
            return;
        }
        super.chooseDecomposition();
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    private String[] getWs(String s) {
        String[] w = new String[4];
        String temp = s;
        int i = 0;
        while (i < 3) {
            int c = temp.indexOf(99);
            if (c == -1) {
                return null;
            }
            w[i] = temp.substring(0, c);
            temp = temp.substring(c + 1);
            ++i;
        }
        w[3] = temp;
        return w;
    }

    private int[] checkIfPossibility(String s0, String s1, int shift) {
        if (s0.length() == 1 && s1.length() == 1) {
            return null;
        }
        if (s0.length() == 1) {
            int[] nArray = new int[4];
            nArray[0] = shift + s0.length() + 1;
            nArray[1] = 1;
            return nArray;
        }
        if (s1.length() == 1 || !s0.equals(s1)) {
            int[] nArray = new int[4];
            nArray[0] = shift;
            nArray[1] = 1;
            return nArray;
        }
        if (this.m >= s1.length() + 2) {
            return new int[]{shift, 1, s0.length(), 1};
        }
        int i = s1.length() - this.m + 2;
        while (i < s1.length()) {
            int j = 0;
            while (j < i) {
                if (s1.charAt(i) == s1.charAt(j)) {
                    String first = String.valueOf(s1.substring(0, i)) + W1CW2CW3CW4.pumpString("" + s1.charAt(i), 2) + s1.substring(i + 1, s1.length());
                    String last = String.valueOf(s1.substring(0, j)) + W1CW2CW3CW4.pumpString("" + s1.charAt(j), 2) + s1.substring(j + 1, s1.length());
                    int x = s1.length() - i + j;
                    if (first.equals(last) && x <= this.m - 2) {
                        return new int[]{shift + i, 1, x, 1};
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 7};
    }

    @Override
    public boolean isInLang(String s) {
        String[] w = this.getWs(s);
        if (w == null) {
            return false;
        }
        char[] list = new char[]{'a', 'b'};
        int i = 0;
        while (i < 4) {
            if (LemmaMath.otherCharactersFound(w[i], list) || w[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return w[0].equals(w[1]) || w[2].equals(w[3]);
    }
}

