/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AnBnCn
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^n b^n c^n";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>n</sup>c<sup>n</sup></i> : <i>n</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i></sup>b<sup><i>m</i></sup>c<sup><i>m</i></sup>\".  With this example, it is impossible to have \"a\"s, \"b\"s, and \"c\"s in both <i>v</i> and <i>y</i> together.  Thus, if <i>i</i> " + NOT_EQUAL + " 1, an inequality will be generated, meaning this is not a " + "context-free language.";
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(AnBnCn.pumpString("a", this.m)) + AnBnCn.pumpString("b", this.m) + AnBnCn.pumpString("c", this.m);
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 11};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 1;
                nArray[1] = 1;
                nArray[3] = AnBnCn.this.m - 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBnCn.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBnCn.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AnBnCn.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AnBnCn.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b', 'c'};
        if (LemmaMath.isMixture(s, list)) {
            return false;
        }
        int a = LemmaMath.countInstances(s, 'a');
        int b = LemmaMath.countInstances(s, 'b');
        int c = LemmaMath.countInstances(s, 'c');
        return a == b && a == c;
    }
}

