/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AkBnCnDj
extends ContextFreePumpingLemma {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTitle() {
        return "a^k b^n c^n d^j : j != k";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>k</sup>b<sup>n</sup>c<sup>n</sup>d<sup>j</sup></i> : <i>j</i> " + NOT_EQUAL + " k";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a context-free language, a valid decomposition exists.  For all m " + GREATER_OR_EQ + " 2, " + "if <i>n</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"b\" and <i>y</i> could equal \"c\".  If <i>n</i> " + "= 0 and <i>k</i> & <i>j</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"a\" and <i>y</i> could equal " + "\"d\".  If <i>n</i> = 0 and only one of <i>k</i> or <i>j</i> " + GREATER_OR_EQ + " 1, <i>v</i> could equal \"a\" " + "or \"d\" (whichever one is in the string).  and <i>y</i> could be empty.  This covers all possible combinations.";
    }

    @Override
    public void chooseI() {
        int da = LemmaMath.countInstances(this.getV(), 'a') + LemmaMath.countInstances(this.getY(), 'a');
        this.i = da == 1 ? 2 : 0;
    }

    @Override
    protected void chooseW() {
        this.w = String.valueOf(AkBnCnDj.pumpString("a", this.m)) + AkBnCnDj.pumpString("b", this.m) + AkBnCnDj.pumpString("c", this.m) + AkBnCnDj.pumpString("d", this.m + 1);
    }

    @Override
    public void chooseDecomposition() {
        int a = this.w.indexOf(97);
        int b = this.w.indexOf(98);
        int c = this.w.indexOf(99);
        int d = this.w.indexOf(100);
        if (b > -1 && c > -1) {
            int[] nArray = new int[4];
            nArray[0] = c - 1;
            nArray[1] = 1;
            nArray[3] = 1;
            this.setDecomposition(nArray);
        } else if (a > -1 && d > -1) {
            int[] nArray = new int[4];
            nArray[0] = d - 1;
            nArray[1] = 1;
            nArray[3] = 1;
            this.setDecomposition(nArray);
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 5};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") > -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") > -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AkBnCnDj.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AkBnCnDj.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") > -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AkBnCnDj.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") == -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = AkBnCnDj.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") > -1 && y.indexOf("c") > -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") == -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") > -1 && v.indexOf("c") > -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1 && y.indexOf("d") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") > -1 && y.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s followed by \"d\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 3 * AkBnCnDj.this.m - 2;
                nArray[1] = 1;
                nArray[3] = 2;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && v.indexOf("d") == -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1 && y.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 3 * AkBnCnDj.this.m - 1;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") > -1 && v.indexOf("d") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1 && y.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s followed by \"d\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 3 * AkBnCnDj.this.m - 1;
                nArray[1] = 2;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.indexOf("a") == -1 && v.indexOf("b") == -1 && v.indexOf("c") == -1 && v.indexOf("d") > -1 && y.indexOf("a") == -1 && y.indexOf("b") == -1 && y.indexOf("c") == -1 && y.indexOf("d") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"d\"s and y is a string of \"d\"s";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 3 * AkBnCnDj.this.m;
                nArray[1] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() == 0 && y.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m;
                nArray[2] = 1;
                nArray[3] = 1;
                return nArray;
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String v, String y) {
                return v.length() > 0 && y.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                int[] nArray = new int[4];
                nArray[0] = 2 * AkBnCnDj.this.m;
                nArray[1] = 1;
                return nArray;
            }
        });
    }

    @Override
    public boolean isInLang(String s) {
        char[] list = new char[]{'a', 'b', 'c', 'd'};
        if (LemmaMath.isMixture(s, list)) {
            return false;
        }
        int[] sections = new int[4];
        int i = 0;
        int j = 0;
        while (i < s.length()) {
            if (s.charAt(i) != list[j]) {
                ++j;
                continue;
            }
            int n = j;
            sections[n] = sections[n] + 1;
            ++i;
        }
        return sections[1] == sections[2] && sections[0] != sections[3];
    }
}

