/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import gui.environment.Universe;
import java.io.Serializable;
import pumping.Case;
import pumping.LemmaMath;
import pumping.PumpingLemma;

public abstract class ContextFreePumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected String u;
    protected String v;
    protected String x;
    protected String y;
    protected String z;

    public String getU() {
        return this.u;
    }

    public String getV() {
        return this.v;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    @Override
    public String getDecompositionAsString() {
        String[] s = new String[5];
        int counter = 0;
        int i = 0;
        while (i <= 3) {
            s[i] = this.w.substring(counter, counter + this.myDecomposition[i]);
            counter += this.myDecomposition[i];
            ++i;
        }
        s[4] = this.w.substring(counter);
        i = 0;
        while (i < s.length) {
            if (s[i].length() == 0) {
                s[i] = Universe.curProfile.getEmptyString();
            }
            ++i;
        }
        return "U = " + s[0] + ";   V = " + s[1] + ";   X = " + s[2] + ";   Y = " + s[3] + ";   Z = " + s[4];
    }

    @Override
    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.u = "";
        this.v = "";
        this.x = "";
        this.y = "";
        this.z = "";
    }

    @Override
    public boolean setDecomposition(int[] decomposition) {
        this.myDecomposition = decomposition;
        int uLength = decomposition[0];
        int vLength = decomposition[1];
        int xLength = decomposition[2];
        int yLength = decomposition[3];
        if (vLength + xLength + yLength > this.m || vLength + yLength < 1) {
            return false;
        }
        this.u = this.w.substring(0, uLength);
        this.v = this.w.substring(uLength, uLength + vLength);
        this.x = this.w.substring(uLength + vLength, uLength + vLength + xLength);
        this.y = this.w.substring(uLength + vLength + xLength, uLength + vLength + xLength + yLength);
        this.z = this.w.substring(uLength + vLength + xLength + yLength);
        return true;
    }

    @Override
    public boolean setDecomposition(int[] decomposition, int num) {
        this.i = num;
        return this.setDecomposition(decomposition);
    }

    @Override
    public String createPumpedString() {
        return String.valueOf(this.u) + ContextFreePumpingLemma.pumpString(this.v, this.getI()) + this.x + ContextFreePumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    @Override
    public int addCase(int[] decomposition, int num) {
        if (!this.setDecomposition(decomposition)) {
            return -1;
        }
        int j = 0;
        while (j < this.myDoneCases.size()) {
            if (((Case)this.myDoneCases.get(j)).isCase(this.v, this.y)) {
                return j;
            }
            ++j;
        }
        j = 0;
        while (j < this.myAllCases.size()) {
            Case c = (Case)this.myAllCases.get(j);
            if (c.isCase(this.v, this.y)) {
                c.setI(num);
                c.setUserInput(decomposition);
                this.myDoneCases.add(c);
                return this.myAllCases.size();
            }
            ++j;
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[], int)");
        return -1;
    }

    @Override
    public boolean replaceCase(int[] decomposition, int num, int index) {
        Case c = (Case)this.myDoneCases.get(index);
        if (c.isCase(this.v, this.y)) {
            c.setI(num);
            c.setUserInput(decomposition);
            return true;
        }
        return false;
    }

    private void chooseDecompositionWithoutCases() {
        int[] decomp = new int[4];
        int counter = 0;
        int temp = 0;
        decomp[0] = LemmaMath.fetchRandInt(0, this.w.length() - 1);
        temp = Math.min(this.w.length() - (counter += decomp[0]), this.m);
        decomp[1] = LemmaMath.fetchRandInt(0, temp);
        if (decomp[1] == this.w.length() - counter) {
            decomp[2] = 0;
            decomp[3] = 0;
        } else {
            temp = Math.min(this.w.length() - (counter += decomp[1]) - 1, this.m - 1);
            decomp[2] = LemmaMath.fetchRandInt(0, temp);
            temp = Math.min(this.w.length() - (counter += decomp[2]), this.m - decomp[2]);
            decomp[3] = decomp[1] > 0 ? LemmaMath.fetchRandInt(0, temp) : LemmaMath.fetchRandInt(1, temp);
        }
        this.setDecomposition(decomp);
    }

    @Override
    public void chooseDecomposition() {
        this.chooseDecompositionWithoutCases();
    }
}

