/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Transition;
import gui.viewer.CurvedArrow;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

public class InvisibleCurvedArrow
extends CurvedArrow {
    public InvisibleCurvedArrow(int x1, int y1, int x2, int y2, float curvy, Transition t) {
        super(x1, y1, x2, y2, curvy, t);
    }

    public InvisibleCurvedArrow(Point start, Point end, float curvy, Transition t) {
        super(start, end, curvy, t);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        this.drawText(g);
    }

    @Override
    public void drawHighlight(Graphics2D g) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(6.0f));
        g2.setColor(HIGHLIGHT_COLOR);
        g2.transform(this.affineToText);
        g2.fill(this.bounds);
        g2.dispose();
    }

    @Override
    public Rectangle2D getBounds() {
        Area area = new Area(this.bounds);
        area.transform(this.affineToText);
        return area.getBounds();
    }

    @Override
    public boolean isNear(Point point, int fudge) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        try {
            if (this.bounds.contains(this.affineToText.inverseTransform(point, null))) {
                return true;
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return false;
    }
}

