/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Transition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CurvedArrow {
    protected Point start;
    protected Point end;
    protected Point control;
    private Point high = new Point();
    protected float curvy;
    protected QuadCurve2D.Float curve;
    protected boolean needsRefresh = true;
    protected boolean startArrow = false;
    protected boolean endArrow = false;
    protected String label = "";
    private static double ARROW_ANGLE = 0.3141592653589793;
    private static double ARROW_LENGTH = 15.0;
    private static AffineTransform AFFINE_TURN_180;
    protected Rectangle2D bounds = new Rectangle(0, 0);
    protected AffineTransform affineToText;
    private static final int CHARS_PER_STEP = 4;
    protected static Graphics GRAPHICS;
    protected static FontMetrics METRICS;
    private static double HEIGHT;
    public static Color HIGHLIGHT_COLOR;
    public static Color ARROW_COLOR;
    public Transition myTransition;

    static {
        GRAPHICS = null;
        AFFINE_TURN_180 = new AffineTransform();
        AFFINE_TURN_180.rotate(Math.PI);
        BufferedImage image = new BufferedImage(1, 1, 1);
        GRAPHICS = image.getGraphics();
        METRICS = GRAPHICS.getFontMetrics();
        HEIGHT = 30.0;
        HIGHLIGHT_COLOR = new Color(255, 0, 0);
        ARROW_COLOR = new Color(0, 0, 0);
    }

    public CurvedArrow(int x1, int y1, int x2, int y2, float curvy, Transition t) {
        this.curve = new QuadCurve2D.Float();
        this.start = new Point();
        this.end = new Point();
        this.control = new Point();
        this.setStart(x1, y1);
        this.setEnd(x2, y2);
        this.setCurvy(curvy);
        this.myTransition = t;
        this.refreshCurve();
    }

    public CurvedArrow(Point start, Point end, float curvy, Transition t) {
        this.curve = new QuadCurve2D.Float();
        this.setStart(start);
        this.setEnd(end);
        this.control = new Point();
        this.setCurvy(curvy);
        this.myTransition = t;
        this.refreshCurve();
    }

    public void setStart(int x1, int y1) {
        this.start.x = x1;
        this.start.y = y1;
        this.needsRefresh = true;
    }

    public void setStart(Point start) {
        this.start = start;
        this.needsRefresh = true;
    }

    public void setEnd(int x2, int y2) {
        this.end.x = x2;
        this.end.y = y2;
        this.needsRefresh = true;
    }

    public void setEnd(Point end) {
        this.end = end;
        this.needsRefresh = true;
    }

    public void setCurvy(float curvy) {
        this.curvy = curvy;
        this.needsRefresh = true;
    }

    public void draw(Graphics2D g) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        g.setColor(ARROW_COLOR);
        g.draw(this.curve);
        this.drawArrow(g, this.end, this.control);
        this.drawText(g);
    }

    public void drawControlPoint(Graphics2D g) {
        g.drawOval((int)this.curve.getCtrlX() - 5, (int)this.curve.getCtrlY() - 5, 10, 10);
    }

    public void drawHighlight(Graphics2D g) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(6.0f));
        g2.setColor(HIGHLIGHT_COLOR);
        g2.draw(this.curve);
        g2.transform(this.affineToText);
        g2.fill(this.bounds);
        g2.dispose();
    }

    public void drawText(Graphics2D g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.transform(this.affineToText);
        FontMetrics metrics = g2.getFontMetrics();
        this.bounds = metrics.getStringBounds(this.getLabel(), g2);
        boolean upsideDown = this.end.x < this.start.x;
        float dx = (float)this.bounds.getWidth() / 2.0f;
        float dy = this.curvy < 0.0f ^ upsideDown ? metrics.getAscent() : -metrics.getDescent();
        this.bounds.setRect(this.bounds.getX() - (double)dx, this.bounds.getY() + (double)dy, this.bounds.getWidth(), this.bounds.getHeight());
        g2.setColor(new Color(0, 0, 0));
        int i = 0;
        while (i < this.label.length()) {
            String sublabel = this.label.substring(i, Math.min(i + 4, this.label.length()));
            g2.drawString(sublabel, -dx, dy);
            dx = (float)((double)dx - metrics.getStringBounds(sublabel, g2).getWidth());
            i += 4;
        }
        g2.dispose();
    }

    public void setLabel(String label) {
        this.label = label;
        this.bounds = METRICS.getStringBounds(this.getLabel(), GRAPHICS);
        boolean upsideDown = this.end.x < this.start.x;
        float dx = (float)this.bounds.getWidth() / 2.0f;
        float dy = this.curvy < 0.0f ^ upsideDown ? METRICS.getAscent() : -METRICS.getDescent();
        this.bounds.setRect(this.bounds.getX() - (double)dx, this.bounds.getY() + (double)dy, this.bounds.getWidth(), this.bounds.getHeight());
    }

    public String getLabel() {
        return this.label;
    }

    private void drawArrow(Graphics g, Point head, Point away) {
        double angle = Math.atan2(away.x - head.x, away.y - head.y);
        int endX = (int)(Math.sin(angle += ARROW_ANGLE) * ARROW_LENGTH) + head.x;
        int endY = (int)(Math.cos(angle) * ARROW_LENGTH) + head.y;
        g.drawLine(head.x, head.y, endX, endY);
        endX = (int)(Math.sin(angle -= 2.0 * ARROW_ANGLE) * ARROW_LENGTH) + head.x;
        endY = (int)(Math.cos(angle) * ARROW_LENGTH) + head.y;
        g.drawLine(head.x, head.y, endX, endY);
    }

    public void refreshCurve() {
        double factory;
        this.needsRefresh = false;
        double lengthx = this.end.x - this.start.x;
        double lengthy = this.end.y - this.start.y;
        double centerx = (double)(this.start.x + this.end.x) / 2.0;
        double centery = (double)(this.start.y + this.end.y) / 2.0;
        double length = Math.sqrt(lengthx * lengthx + lengthy * lengthy);
        double factorx = length == 0.0 ? 0.0 : lengthx / length;
        double d = factory = length == 0.0 ? 0.0 : lengthy / length;
        if (this.myTransition.getControl() == null) {
            this.control.x = (int)(centerx + (double)this.curvy * HEIGHT * factory);
            this.control.y = (int)(centery - (double)this.curvy * HEIGHT * factorx);
            this.high.x = (int)(centerx + (double)this.curvy * HEIGHT * factory / 2.0);
            this.high.y = (int)(centery - (double)this.curvy * HEIGHT * factorx / 2.0);
        } else {
            this.control.x = this.myTransition.getControl().x;
            this.control.y = this.myTransition.getControl().y;
            double xt = (double)this.control.x - centerx;
            double yt = centery - (double)this.control.y;
            this.high.x = (int)(centerx + xt / 2.0);
            this.high.y = (int)(centery - yt / 2.0);
        }
        this.curve.setCurve(this.start.x, this.start.y, this.control.x, this.control.y, this.end.x, this.end.y);
        this.affineToText = new AffineTransform();
        this.affineToText.translate(this.high.x, this.high.y);
        this.affineToText.rotate(Math.atan2(lengthy, lengthx));
        if (this.end.x < this.start.x) {
            this.affineToText.rotate(Math.PI);
        }
    }

    public Rectangle2D getBounds() {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Rectangle b = this.curve.getBounds();
        Area area = new Area(this.bounds);
        area.transform(this.affineToText);
        b.add((Rectangle2D)area.getBounds());
        return b;
    }

    public boolean isNear(Point point, int fudge) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        try {
            if (this.bounds.contains(this.affineToText.inverseTransform(point, null))) {
                return true;
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
        }
        catch (NullPointerException e) {
            System.err.println(e + " : " + this.bounds + " : " + this.affineToText);
            return false;
        }
        return this.intersects(point, fudge, this.curve);
    }

    private boolean intersects(Point point, int fudge, QuadCurve2D.Float c) {
        if (!c.intersects(point.x - fudge, point.y - fudge, fudge << 1, fudge << 1)) {
            return false;
        }
        if (c.getFlatness() < (double)fudge) {
            return true;
        }
        QuadCurve2D.Float f1 = new QuadCurve2D.Float();
        QuadCurve2D.Float f2 = new QuadCurve2D.Float();
        c.subdivide(f1, f2);
        return this.intersects(point, fudge, f1) || this.intersects(point, fudge, f2);
    }

    public QuadCurve2D getCurve() {
        return this.curve;
    }
}

