/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultTreeDrawer;
import java.awt.Color;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SelectTreeDrawer
extends DefaultTreeDrawer {
    protected WeakHashMap<TreeNode, ?> selectedNodes = new WeakHashMap();
    protected Color deselectedColor = NODE_COLOR;
    protected Color selectedColor = SELECTED_NODE_COLOR;
    public static final Color NODE_COLOR = Color.yellow;
    public static final Color SELECTED_NODE_COLOR = NODE_COLOR.darker();

    public SelectTreeDrawer(TreeModel tree) {
        this(tree, NODE_COLOR, SELECTED_NODE_COLOR);
    }

    public SelectTreeDrawer(TreeModel tree, Color deselected, Color selected) {
        super(tree);
        this.deselectedColor = deselected;
        this.selectedColor = selected;
    }

    public boolean isSelected(TreeNode node) {
        return this.selectedNodes.containsKey(node);
    }

    public void setSelected(TreeNode node, boolean select) {
        if (select) {
            this.selectedNodes.put(node, null);
        } else {
            this.selectedNodes.remove(node);
        }
    }

    public TreeNode[] getSelected() {
        HashSet<TreeNode> s = new HashSet<TreeNode>(this.selectedNodes.keySet());
        for (TreeNode n : s) {
            if (n.getParent() != null || n == this.getModel().getRoot()) continue;
            this.selectedNodes.remove(n);
        }
        return this.selectedNodes.keySet().toArray(new TreeNode[0]);
    }

    public void clearSelected() {
        this.selectedNodes.clear();
    }

    @Override
    protected Color getNodeColor(TreeNode node) {
        return this.isSelected(node) ? this.selectedColor : this.deselectedColor;
    }
}

