/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.NodeDrawer;
import gui.tree.NodePlacer;
import gui.tree.Trees;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class LeafNodePlacer
implements NodePlacer {
    @Override
    public Map<TreeNode, Point2D.Float> placeNodes(TreeModel tree, NodeDrawer drawer) {
        HashMap<TreeNode, Point2D.Float> nodeToPoint = new HashMap<TreeNode, Point2D.Float>();
        int[] width = Trees.width(tree);
        TreeNode[] leaves = Trees.leaves(tree);
        int depth = Trees.depth(tree);
        this.setPoints((TreeNode)tree.getRoot(), depth, 0, leaves.length, new int[1], nodeToPoint);
        return nodeToPoint;
    }

    private void setPoints(TreeNode node, int depth, int thisDepth, int leaves, int[] sofar, Map<TreeNode, Point2D.Float> nodeToPoint) {
        TreeNode[] children = Trees.children(node);
        float y = (float)(thisDepth + 1) / (float)(depth + 2);
        if (children.length == 0) {
            float x = (float)(sofar[0] + 1) / (float)(leaves + 1);
            nodeToPoint.put(node, new Point2D.Float(x, y));
            sofar[0] = sofar[0] + 1;
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.setPoints(children[i], depth, thisDepth + 1, leaves, sofar, nodeToPoint);
            ++i;
        }
        Point2D leftmost = nodeToPoint.get(children[0]);
        Point2D rightmost = nodeToPoint.get(children[children.length - 1]);
        float x = (float)((leftmost.getX() + rightmost.getX()) / 2.0);
        nodeToPoint.put(node, new Point2D.Float(x, y));
    }
}

