/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.NodeDrawer;
import gui.tree.NodePlacer;
import gui.tree.Trees;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DefaultNodePlacer
implements NodePlacer {
    @Override
    public Map<TreeNode, Point2D.Float> placeNodes(TreeModel tree, NodeDrawer drawer) {
        HashMap<TreeNode, Point2D.Float> nodeToPoint = new HashMap<TreeNode, Point2D.Float>();
        int[] width = Trees.width(tree);
        int[] sofar = new int[width.length];
        Arrays.fill(sofar, 0);
        this.setPoints((TreeNode)tree.getRoot(), width.length - 1, 0, width, sofar, nodeToPoint);
        return nodeToPoint;
    }

    private void setPoints(TreeNode node, int depth, int thisDepth, int[] width, int[] widthSofar, Map<TreeNode, Point2D.Float> nodeToPoint) {
        float x = (float)(widthSofar[thisDepth] + 1) / (float)(width[thisDepth] + 1);
        float y = (float)(thisDepth + 1) / (float)(depth + 2);
        nodeToPoint.put(node, new Point2D.Float(x, y));
        int n = thisDepth++;
        widthSofar[n] = widthSofar[n] + 1;
        TreeNode[] children = Trees.children(node);
        int i = 0;
        while (i < children.length) {
            this.setPoints(children[i], depth, thisDepth, width, widthSofar, nodeToPoint);
            ++i;
        }
    }
}

