/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.environment.Universe;
import gui.tree.NodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.tree.TreeNode;

public class DefaultNodeDrawer
implements NodeDrawer {
    public static final float NODE_RADIUS = 13.0f;
    public static final Shape NODE_SHAPE = new Ellipse2D.Float(-13.0f, -13.0f, 26.0f, 26.0f);
    public static final Rectangle2D NODE_SIZE = new Rectangle(13, 13, 26, 26);

    @Override
    public void draw(Graphics2D g, TreeNode node) {
        g.fill(NODE_SHAPE);
        Color c = g.getColor();
        g.setColor(Color.black);
        g.draw(NODE_SHAPE);
        String s = node.toString();
        if (s == null) {
            s = "null";
        }
        if (s.length() == 0) {
            s = Universe.curProfile.getEmptyString();
        }
        Rectangle2D bounds = this.getBounds(g, s);
        int dx = (int)bounds.getWidth() >> 1;
        int dy = (int)(-bounds.getY()) >> 1;
        g.drawString(s, -dx, dy);
        g.setColor(c);
    }

    public void draw(Graphics2D g, TreeNode node, boolean dummy) {
        g.fill(new Ellipse2D.Float(-13.0f, -13.0f, 52.0f, 26.0f));
        Color c = g.getColor();
        g.setColor(Color.black);
        g.draw(new Ellipse2D.Float(-13.0f, -13.0f, 52.0f, 26.0f));
        String s = node.toString();
        if (s == null) {
            s = "null";
        }
        if (s.length() == 0) {
            s = Universe.curProfile.getEmptyString();
        }
        Rectangle2D bounds = this.getBounds(g, s);
        int dx = (int)bounds.getWidth() >> 2;
        int dy = (int)(-bounds.getY()) >> 1;
        g.drawString(s, -dx, dy);
        g.setColor(c);
    }

    protected Rectangle2D getBounds(Graphics2D g, String string) {
        return g.getFontMetrics().getStringBounds(string, g);
    }

    @Override
    public Rectangle2D nodeSize() {
        return NODE_SIZE;
    }

    @Override
    public Rectangle2D nodeSize(TreeNode node) {
        return this.nodeSize();
    }

    @Override
    public boolean onNode(TreeNode node, double x, double y) {
        return Math.sqrt(x * x + y * y) <= 13.0;
    }
}

