/*
 * Decompiled with CFR 0.152.
 */
package gui.transform;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class Matrix
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public double[][] entry;
    private double[][] entry2 = new double[4][4];
    private static double XAXIS_ANGLE = Double.NaN;
    private static double YAXIS_ANGLE = Double.NaN;
    private static double ZAXIS_ANGLE = Double.NaN;
    private static Matrix XAXIS_TURN;
    private static Matrix YAXIS_TURN;
    private static Matrix ZAXIS_TURN;
    private static double[] DIRS;
    private static final Matrix TRANSLATE;
    private static final Matrix INVERSE;
    private static final double[] ORIGIN_REUSE;

    static {
        DIRS = new double[]{0.0, 0.0, 0.0};
        TRANSLATE = new Matrix();
        INVERSE = new Matrix();
        ORIGIN_REUSE = new double[3];
    }

    public Matrix() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public Matrix(double a11, double a12, double a13, double a14, double a21, double a22, double a23, double a24, double a31, double a32, double a33, double a34) {
        this.entry = new double[][]{{a11, a12, a13, a14}, {a21, a22, a23, a24}, {a31, a32, a33, a34}, {0.0, 0.0, 0.0, 1.0}};
    }

    public Matrix(Matrix m) {
        this(m.entry[0][0], m.entry[0][1], m.entry[0][2], m.entry[0][3], m.entry[1][0], m.entry[1][1], m.entry[1][2], m.entry[1][3], m.entry[2][0], m.entry[2][1], m.entry[2][2], m.entry[2][3]);
    }

    public Object clone() {
        return new Matrix(this);
    }

    public final double valueAt(int row, int column) {
        return this.entry[row][column];
    }

    public final void premultiply(Matrix matrix) {
        this.entry[3][2] = 0.0;
        this.entry[3][1] = 0.0;
        this.entry2[3][0] = 0.0;
        this.entry2[3][3] = 1.0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 4) {
                this.entry2[i][j] = 0.0;
                int k = 0;
                while (k < 4) {
                    double[] dArray = this.entry2[i];
                    int n = j;
                    dArray[n] = dArray[n] + matrix.entry[i][k] * this.entry[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double[][] oldentry = this.entry;
        this.entry = this.entry2;
        this.entry2 = oldentry;
    }

    public final void postmultiply(Matrix matrix) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.entry2[i][j] = 0.0;
                int k = 0;
                while (k < 4) {
                    double[] dArray = this.entry2[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.entry[i][k] * matrix.entry[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double[][] oldentry = this.entry;
        this.entry = this.entry2;
        this.entry2 = oldentry;
    }

    public final void pitch(double angle) {
        if (XAXIS_ANGLE == -angle) {
            XAXIS_ANGLE = angle;
            Matrix.XAXIS_TURN.entry[1][2] = -Matrix.XAXIS_TURN.entry[1][2];
            Matrix.XAXIS_TURN.entry[2][1] = -Matrix.XAXIS_TURN.entry[2][1];
        } else if (XAXIS_ANGLE != angle) {
            XAXIS_ANGLE = angle;
            angle = Math.toRadians(angle);
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            XAXIS_TURN = new Matrix(1.0, 0.0, 0.0, 0.0, 0.0, c, -s, 0.0, 0.0, s, c, 0.0);
        }
        this.premultiply(XAXIS_TURN);
    }

    public final void roll(double angle) {
        if (YAXIS_ANGLE == -angle) {
            YAXIS_ANGLE = angle;
            Matrix.YAXIS_TURN.entry[0][2] = -Matrix.YAXIS_TURN.entry[0][2];
            Matrix.YAXIS_TURN.entry[2][0] = -Matrix.YAXIS_TURN.entry[2][0];
        } else if (YAXIS_ANGLE != angle) {
            YAXIS_ANGLE = angle;
            angle = Math.toRadians(angle);
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            YAXIS_TURN = new Matrix(c, 0.0, s, 0.0, 0.0, 1.0, 0.0, 0.0, -s, 0.0, c, 0.0);
        }
        this.premultiply(YAXIS_TURN);
    }

    public final void yaw(double angle) {
        if (ZAXIS_ANGLE == -angle) {
            ZAXIS_ANGLE = angle;
            Matrix.ZAXIS_TURN.entry[0][1] = -Matrix.ZAXIS_TURN.entry[0][1];
            Matrix.ZAXIS_TURN.entry[1][0] = -Matrix.ZAXIS_TURN.entry[1][0];
        } else if (ZAXIS_ANGLE != angle) {
            ZAXIS_ANGLE = angle;
            angle = Math.toRadians(angle);
            double c = Math.cos(angle);
            double s = Math.sin(angle);
            ZAXIS_TURN = new Matrix(c, -s, 0.0, 0.0, s, c, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        }
        this.premultiply(ZAXIS_TURN);
    }

    public final void translate(double x, double y, double z) {
        if (DIRS[0] != x || DIRS[1] != y || DIRS[2] != z) {
            double d = x;
            Matrix.TRANSLATE.entry[0][3] = d;
            Matrix.DIRS[0] = d;
            double d2 = y;
            Matrix.TRANSLATE.entry[1][3] = d2;
            Matrix.DIRS[1] = d2;
            double d3 = z;
            Matrix.TRANSLATE.entry[2][3] = d3;
            Matrix.DIRS[2] = d3;
        }
        this.premultiply(TRANSLATE);
    }

    public final Point2D origin(Point2D point) {
        if (point == null) {
            point = new Point2D.Double();
        }
        this.origin(ORIGIN_REUSE);
        point.setLocation(ORIGIN_REUSE[0], ORIGIN_REUSE[1]);
        return point;
    }

    public final double[] origin(double[] array) {
        if (array == null) {
            array = new double[3];
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                Matrix.INVERSE.entry[i][j] = this.entry[j][i];
                ++j;
            }
            ++i;
        }
        this.premultiply(INVERSE);
        i = 0;
        while (i < 3) {
            array[i] = this.entry[i][3];
            ++i;
        }
        double[][] old = this.entry;
        this.entry = this.entry2;
        this.entry2 = old;
        return array;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        int i = 0;
        while (i < 4) {
            if (i != 0) {
                sb.append(";  ");
            }
            int j = 0;
            while (j < 4) {
                if (j != 0) {
                    sb.append(',');
                }
                sb.append(' ');
                sb.append(this.entry[i][j]);
                ++j;
            }
            ++i;
        }
        sb.append(" )");
        return sb.toString();
    }

    public static final String arrayString(double[] d) {
        return "( " + d[0] + ", " + d[1] + ", " + d[2] + " )";
    }
}

