/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import gui.TooltipAction;
import gui.sim.ConfigurationController;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;

public class ControlPanel
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private boolean blockStep = false;
    private ConfigurationController controller;

    public ControlPanel(ConfigurationController controller) {
        this.controller = controller;
        this.initView();
    }

    public ConfigurationController getController() {
        return this.controller;
    }

    protected void initView() {
        this.add(new TooltipAction("Step", "Moves existing valid configurations to the next configurations."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.step(ControlPanel.this.blockStep);
            }
        });
        this.add(new TooltipAction("Reset", "Resets the simulation to start conditions."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.reset();
            }
        });
        if (this.controller.isTuringMachine()) {
            this.add(new AbstractAction("Focus"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.controller.focus();
                }
            });
            this.add(new AbstractAction("Defocus"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.controller.defocus();
                }
            });
        }
        this.add(new AbstractAction("Freeze"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.freeze();
            }
        });
        this.add(new AbstractAction("Thaw"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.thaw();
            }
        });
        this.add(new AbstractAction("Trace"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.trace();
            }
        });
        this.add(new AbstractAction("Remove"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.remove();
            }
        });
    }

    public void setBlock(boolean step) {
        this.blockStep = step;
    }
}

