/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.Configuration;
import gui.sim.ConfigurationButton;
import gui.sim.ConfigurationSelectionEvent;
import gui.sim.ConfigurationSelectionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;

public class ConfigurationPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Automaton automaton;
    private HashMap<Configuration, ConfigurationButton> configurationToButtonMap = new HashMap();
    private HashSet<Configuration> selected = new HashSet();
    private transient HashSet<ConfigurationSelectionListener> selectionListeners = new HashSet();

    public ConfigurationPane(Automaton automaton) {
        this.automaton = automaton;
    }

    public void add(Configuration configuration) {
        this.add(configuration, 0);
    }

    public void add(Configuration configuration, int state) {
        if (this.contains(configuration)) {
            return;
        }
        ConfigurationButton button = new ConfigurationButton(configuration, state);
        this.configurationToButtonMap.put(configuration, button);
        this.add(button);
        button.addActionListener(this);
    }

    public int getState(Configuration configuration) {
        return this.configurationToButtonMap.get((Object)configuration).state;
    }

    public boolean contains(Configuration configuration) {
        return this.configurationToButtonMap.containsKey(configuration);
    }

    public void setReject(Configuration configuration) {
        ConfigurationButton button = this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(2);
        }
        button.doClick();
    }

    public void setFrozen(Configuration configuration) {
        ConfigurationButton button = this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(3);
        }
        button.doClick();
    }

    public void setFocused(Configuration configuration) {
        ConfigurationButton button = this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(4);
            button.doClick();
        }
    }

    public void defocus(Configuration configuration) {
        this.setNormal(configuration);
        Configuration parent = configuration;
        parent.setFocused(false);
        while (parent.getParent() != null) {
            parent = parent.getParent();
            parent.setFocused(false);
        }
    }

    public void setNormal(Configuration configuration) {
        ConfigurationButton button = this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 3) {
            button.setState(0);
        } else if (button.state == 4) {
            button.setState(0);
        }
        button.doClick();
    }

    public void remove(Configuration configuration) {
        Component comp = this.configurationToButtonMap.remove(configuration);
        if (comp == null) {
            return;
        }
        this.selected.remove(configuration);
        this.remove(comp);
    }

    public void clear() {
        this.configurationToButtonMap.clear();
        this.selected.clear();
        super.removeAll();
    }

    public void deselectAll() {
        this.selected.clear();
    }

    public Configuration[] getSelected() {
        return this.selected.toArray(new Configuration[0]);
    }

    public Configuration[] getConfigurations() {
        return this.configurationToButtonMap.keySet().toArray(new Configuration[0]);
    }

    public Configuration[] getValidConfigurations() {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        for (ConfigurationButton button : this.configurationToButtonMap.values()) {
            if (button.state != 0 && button.state != 4) continue;
            list.add(button.getConfiguration());
        }
        return list.toArray(new Configuration[0]);
    }

    public void clearFinal() {
        ArrayList<ConfigurationButton> list = new ArrayList<ConfigurationButton>();
        list.addAll(this.configurationToButtonMap.values());
        for (ConfigurationButton button : list) {
            if (button.state != 1 && button.state != 2) continue;
            this.remove(button.getConfiguration());
        }
    }

    public void clearThawed() {
        ArrayList<ConfigurationButton> list = new ArrayList<ConfigurationButton>();
        list.addAll(this.configurationToButtonMap.values());
        for (ConfigurationButton button : list) {
            if (button.state == 3) continue;
            this.remove(button.getConfiguration());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ConfigurationButton button = null;
        try {
            button = (ConfigurationButton)e.getSource();
        }
        catch (ClassCastException ex) {
            return;
        }
        Configuration config = button.getConfiguration();
        if (!this.configurationToButtonMap.containsKey(config)) {
            return;
        }
        if (button.isSelected()) {
            this.selected.add(config);
        } else {
            this.selected.remove(config);
        }
        this.distributeSelectionEvent(new ConfigurationSelectionEvent(this));
    }

    public void addSelectionListener(ConfigurationSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ConfigurationSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    void distributeSelectionEvent(ConfigurationSelectionEvent event) {
        for (ConfigurationSelectionListener listener : this.selectionListeners) {
            listener.configurationSelectionChange(event);
        }
    }
}

