/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import gui.TextFieldSizeSlider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import regular.ExpressionChangeEvent;
import regular.ExpressionChangeListener;
import regular.RegularExpression;

public class EditorPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private RegularExpression expression;
    private JTextField field = new JTextField("");
    private ExpressionChangeListener listener = new ExpressionChangeListener(){

        @Override
        public void expressionChanged(ExpressionChangeEvent e) {
            EditorPane.this.field.setText(e.getExpression().asString());
        }
    };
    private Reference<String> ref = new WeakReference<String>(null){

        @Override
        public String get() {
            return EditorPane.this.field.getText();
        }
    };

    public EditorPane(RegularExpression expression) {
        this.expression = expression;
        this.field.setText(expression.asString());
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditorPane.this.updateExpression();
            }
        });
        this.field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPane.this.updateExpression();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)new JLabel("Edit the regular expression below:"), c);
        this.add((Component)this.field, c);
        this.add((Component)new TextFieldSizeSlider(this.field, 0, "Input Field Text Size (For optimiztion, adjust the size of this window after resizing the text field)"), c);
    }

    private void updateExpression() {
        this.expression.change(this.ref);
    }
}

