/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.EnvironmentFrame;
import gui.environment.RegularEnvironment;
import gui.environment.Universe;
import gui.regular.DeexpressionifyTransitionTool;
import gui.regular.REToFSAController;
import gui.regular.RegularToAutomatonTransitionTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import regular.Discretizer;

public class ConvertToAutomatonPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    RegularEnvironment environment;
    private FiniteStateAutomaton automaton = new FiniteStateAutomaton();
    private REToFSAController controller;
    JFrame frame;
    JLabel mainLabel = new JLabel();
    JLabel detailLabel = new JLabel();
    AbstractAction doStepAction = new AbstractAction("Do Step"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvertToAutomatonPane.this.controller.completeStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvertToAutomatonPane.this.controller.completeAll();
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvertToAutomatonPane.this.controller.export();
        }
    };
    AbstractAction exportAction2 = new AbstractAction("Export Now"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ConvertToAutomatonPane.this.controller.exportToTab();
        }
    };

    public ConvertToAutomatonPane(RegularEnvironment environment) {
        this.environment = environment;
        EnvironmentFrame frame = Universe.frameForEnvironment(environment);
        this.setLayout(new BorderLayout());
        JPanel labels = new JPanel(new BorderLayout());
        labels.add((Component)this.mainLabel, "North");
        labels.add((Component)this.detailLabel, "South");
        this.mainLabel.setText(" ");
        this.detailLabel.setText(" ");
        this.add((Component)labels, "North");
        SelectionDrawer automatonDrawer = new SelectionDrawer(this.automaton);
        State initialState = this.automaton.createState(new Point(60, 40));
        State finalState = this.automaton.createState(new Point(450, 250));
        this.automaton.setInitialState(initialState);
        this.automaton.addFinalState(finalState);
        FSATransition initialTransition = new FSATransition(initialState, finalState, Discretizer.delambda(environment.getExpression().asString().replace('!', Universe.curProfile.getEmptyString().charAt(0))));
        this.automaton.addTransition(initialTransition);
        this.controller = new REToFSAController(this, this.automaton);
        EditorPane ep = new EditorPane(automatonDrawer, new ToolBox(){

            @Override
            public List<Tool> tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(view, drawer));
                tools.add(new RegularToAutomatonTransitionTool(view, drawer, ConvertToAutomatonPane.this.controller));
                tools.add(new DeexpressionifyTransitionTool(view, drawer, ConvertToAutomatonPane.this.controller));
                return tools;
            }
        });
        ToolBar bar = ep.getToolBar();
        bar.addSeparator();
        bar.add(this.doStepAction);
        bar.add(this.doAllAction);
        bar.add(this.exportAction);
        this.add((Component)ep, "Center");
    }
}

