/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.fsa.FiniteStateAutomaton;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.regular.CollapseTool;
import gui.regular.FSAToREController;
import gui.regular.RegularStateTool;
import gui.regular.RegularTransitionTool;
import gui.regular.StateCollapseTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConvertPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    AutomatonEnvironment environment;
    private FiniteStateAutomaton automaton;

    public ConvertPane(AutomatonEnvironment environment) {
        this.environment = environment;
        this.automaton = (FiniteStateAutomaton)environment.getAutomaton().clone();
        EnvironmentFrame frame = Universe.frameForEnvironment(environment);
        this.setLayout(new BorderLayout());
        JPanel labels = new JPanel(new BorderLayout());
        JLabel mainLabel = new JLabel();
        JLabel detailLabel = new JLabel();
        labels.add((Component)mainLabel, "North");
        labels.add((Component)detailLabel, "South");
        this.add((Component)labels, "North");
        SelectionDrawer automatonDrawer = new SelectionDrawer(this.automaton);
        final FSAToREController controller = new FSAToREController(this.automaton, automatonDrawer, mainLabel, detailLabel, frame);
        EditorPane ep = new EditorPane(automatonDrawer, new ToolBox(){

            @Override
            public List<Tool> tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowNontransitionTool(view, drawer));
                tools.add(new RegularStateTool(view, drawer, controller));
                tools.add(new RegularTransitionTool(view, drawer, controller));
                tools.add(new CollapseTool(view, drawer, controller));
                tools.add(new StateCollapseTool(view, drawer, controller));
                return tools;
            }
        });
        ToolBar bar = ep.getToolBar();
        bar.addSeparator();
        bar.add(new JButton(new AbstractAction("Do It"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.moveNextStep();
            }
        }));
        bar.add(new JButton(new AbstractAction("Export"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                controller.export();
            }
        }));
        this.add((Component)ep, "Center");
    }
}

