/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.Transition;
import gui.editor.Tool;
import gui.regular.FSAToREController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class CollapseTool
extends Tool {
    private FSAToREController controller;

    public CollapseTool(AutomatonPane view, AutomatonDrawer drawer, FSAToREController controller) {
        super(view, drawer);
        this.controller = controller;
    }

    @Override
    public String getToolTip() {
        return "Transition Collapser";
    }

    @Override
    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/collapse.gif");
        return new ImageIcon(url);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('c');
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Transition t = this.getDrawer().transitionAtPoint(event.getPoint());
        if (t != null) {
            this.controller.transitionCollapse(t.getFromState(), t.getToState());
        }
    }
}

