/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.Canvas;
import gui.pumping.CasePanel;
import gui.pumping.ComputerFirstPane;
import gui.pumping.HumanFirstPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;

public abstract class PumpingLemmaInputPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static Dimension MAX_SIZE = new Dimension(640, 580);
    private static String PROMPT_ANIM = "Click \"Step\" in Box 5 to step the animation.";
    private static String PROMPT_CASE = "Click \"Step\" in Box 5 to step the animation or \"Add\" in the right panel to add this case.";
    protected PumpingLemma myLemma;
    protected JTextComponent myMDisplay;
    protected JTextComponent myWDisplay;
    protected JTextComponent myIDisplay;
    protected JTextArea myPumpedStringDisplay;
    protected Canvas myCanvas;
    protected JButton myStartAnimation;
    protected JButton myStepAnimation;
    protected JEditorPane myLastWord;
    private JTextPane myTopTextPane;
    protected CasePanel myCases;
    protected JPanel leftPanel;
    protected JPanel[] stages;
    protected JLabel[] stageMessages;

    public PumpingLemmaInputPane(PumpingLemma l, String title) {
        this.setLayout(new BorderLayout());
        this.myLemma = l;
        JPanel p = new JPanel(new BorderLayout());
        JEditorPane ep = new JEditorPane("text/html", "<html><body align=center><b>" + title + "</b></body></html>");
        ep.setBackground(this.getBackground());
        ep.setDisabledTextColor(Color.BLACK);
        ep.setEnabled(false);
        p.add((Component)ep, "North");
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.initLeftPanel();
        if (this.myLemma.numCasesTotal() <= 1 || this instanceof ComputerFirstPane) {
            this.leftPanel.setPreferredSize(MAX_SIZE);
            this.leftPanel.setMaximumSize(MAX_SIZE);
            p.add((Component)this.leftPanel, "Center");
        } else {
            JSplitPane splitPane = new JSplitPane(1);
            this.leftPanel.revalidate();
            this.leftPanel.setPreferredSize(new Dimension(400, 300));
            this.leftPanel.setMaximumSize(MAX_SIZE);
            splitPane.setLeftComponent(this.leftPanel);
            JComponent rightPanel = this.initRightPanel();
            rightPanel.setPreferredSize(new Dimension(400, 300));
            rightPanel.setMaximumSize(MAX_SIZE);
            splitPane.setRightComponent(rightPanel);
            p.add((Component)splitPane, "Center");
        }
        JScrollPane scrollPane = new JScrollPane(p);
        this.add((Component)scrollPane, "Center");
        this.setMaximumSize(MAX_SIZE);
        this.setPreferredSize(MAX_SIZE);
    }

    private void initLeftPanel() {
        this.stages = new JPanel[6];
        this.stageMessages = new JLabel[6];
        int i = 0;
        while (i < this.stageMessages.length) {
            this.stageMessages[i] = new JLabel();
            ++i;
        }
        this.stages[0] = this.initTop();
        this.stages[1] = this.initM();
        this.stages[2] = this.initW();
        this.stages[3] = this.initDecompPanel();
        this.stages[4] = this.initI();
        this.stages[5] = this.initCanvas();
        i = 0;
        while (i < this.stages.length) {
            this.leftPanel.add(this.stages[i]);
            ++i;
        }
        if (this instanceof HumanFirstPane) {
            this.stages[2].setVisible(false);
        }
        i = 3;
        while (i < this.stages.length) {
            this.stages[i].setVisible(false);
            ++i;
        }
    }

    private JComponent initRightPanel() {
        this.myCases = new CasePanel((ContextFreePumpingLemma)this.myLemma, this);
        return new JScrollPane(this.myCases);
    }

    private JPanel initTop() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JButton clear = new JButton("Clear All");
        JButton explain = new JButton("Explain");
        this.myTopTextPane = new JTextPane();
        JScrollPane sp = new JScrollPane(this.myTopTextPane);
        this.myTopTextPane.setContentType("text/html");
        this.myTopTextPane.setEditable(false);
        explain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.updateTopPane(true);
            }
        });
        String objectiveText = this.addTopGameFeatures(clear);
        p.add(clear);
        p.add(explain);
        p.add(sp);
        p.setBorder(BorderFactory.createTitledBorder("Objective: " + objectiveText));
        p.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        p.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return p;
    }

    private JPanel initM() {
        JPanel p = new JPanel(new BorderLayout());
        String message = this.addMGameFeatures();
        JPanel q = new JPanel(new BorderLayout());
        q.add((Component)this.myMDisplay, "North");
        q.setBorder(BorderFactory.createTitledBorder("1. " + message));
        q.add((Component)this.stageMessages[1], "South");
        p.add((Component)q, "Center");
        JPanel s = new JPanel();
        s.setLayout(new BoxLayout(s, 0));
        p.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        p.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return p;
    }

    private JPanel initW() {
        JPanel p = new JPanel(new BorderLayout());
        String message = this.addWGameFeatures();
        p.setBorder(BorderFactory.createTitledBorder("2. " + message));
        p.add((Component)this.myWDisplay, "North");
        p.add((Component)this.stageMessages[2], "South");
        p.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        p.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return p;
    }

    protected abstract JPanel initDecompPanel();

    private JPanel initI() {
        JPanel o = new JPanel(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("i: "));
        String message = this.addIGameFeatures();
        p.add(this.myIDisplay);
        p.add(new JLabel("    pumped string: "));
        this.myPumpedStringDisplay = new JTextArea(1, 30);
        this.myPumpedStringDisplay.setEditable(false);
        p.add(this.myPumpedStringDisplay);
        o.setBorder(BorderFactory.createTitledBorder("4. " + message));
        o.add((Component)p, "North");
        o.add(p.add(this.stageMessages[4]), "South");
        o.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        o.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, PumpingLemmaInputPane.MAX_SIZE.height / 10));
        return o;
    }

    private JPanel initCanvas() {
        JPanel p = new JPanel(new BorderLayout());
        this.myCanvas = new Canvas();
        p.add((Component)this.myCanvas, "Center");
        this.myLastWord = new JEditorPane("text/html", "");
        this.myLastWord.setBackground(this.getBackground());
        this.myLastWord.setDisabledTextColor(Color.BLACK);
        this.myLastWord.setEnabled(false);
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 0));
        q.add(this.myLastWord);
        this.myStepAnimation = new JButton("Step");
        this.myStepAnimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.stepAnimation();
                PumpingLemmaInputPane.this.myCanvas.start();
            }
        });
        this.myStepAnimation.setEnabled(false);
        q.add(this.myStepAnimation);
        this.myCanvas.setStepButton(this.myStepAnimation);
        this.myStartAnimation = new JButton("Restart");
        this.myStartAnimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PumpingLemmaInputPane.this.setCanvas();
                PumpingLemmaInputPane.this.myCanvas.stop();
                PumpingLemmaInputPane.this.repaint();
            }
        });
        this.myStartAnimation.setEnabled(false);
        q.add(this.myStartAnimation);
        this.myCanvas.setRestartButton(this.myStartAnimation);
        p.add((Component)this.stageMessages[5], "North");
        p.add((Component)q, "South");
        p.setBorder(BorderFactory.createTitledBorder("5. Animation"));
        p.setMaximumSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, 35 * PumpingLemmaInputPane.MAX_SIZE.height / 100));
        p.setPreferredSize(new Dimension(PumpingLemmaInputPane.MAX_SIZE.width, 35 * PumpingLemmaInputPane.MAX_SIZE.height / 100));
        return p;
    }

    protected void setVisibilityStages(int minStage, boolean visibility) {
        int i = minStage;
        while (i < this.stages.length) {
            this.stages[i].setVisible(visibility);
            ++i;
        }
    }

    protected void resetMessages() {
        int i = 0;
        while (i < this.stageMessages.length) {
            this.stageMessages[i].setText("");
            ++i;
        }
    }

    protected abstract void resetDecompPanel();

    protected void reset() {
        this.myLemma.reset();
        this.resetDecompPanel();
        this.resetMessages();
        if (this.myCases != null) {
            this.myCases.clearAll();
            this.myCases.setMessage("");
            this.myCases.setListButtonEnabled(false);
            this.myCases.setAddReplaceButtonsEnabled(false);
        }
        if (this instanceof HumanFirstPane) {
            this.setVisibilityStages(2, false);
        } else {
            this.setVisibilityStages(3, false);
        }
        this.leftPanel.revalidate();
    }

    public void updateTopPane(boolean printExplanation) {
        String s = "<b>My Attempts:</b>";
        String output = "<html>";
        if (this.stageMessages[0].getText().length() > 0) {
            output = String.valueOf(output) + "<b><i>" + this.stageMessages[0].getText() + "</i></b><br>";
        }
        int i = this.myLemma.getAttempts().size() - 1;
        while (i >= 0) {
            String a = this.myLemma.getAttempts().get(i);
            s = String.valueOf(s) + "<br>" + (i + 1) + ":  " + a;
            --i;
        }
        if (printExplanation) {
            String result = this.myLemma.getPartitionValidity() ? "<b>A valid partition of <i>w</i> exists!</b><br>" : "<b>Unfortunately no valid partition of <i>w</i> exists.</b><br>";
            output = this.myLemma.getAttempts().size() > 0 ? String.valueOf(output) + result + this.myLemma.getExplanation() + "<br><br>" : String.valueOf(output) + result + this.myLemma.getExplanation();
        }
        if (this.myLemma.getAttempts().size() > 0) {
            output = String.valueOf(output) + s;
        }
        output = String.valueOf(output) + "</html>";
        this.myTopTextPane.setText(output);
        this.myTopTextPane.setCaretPosition(0);
    }

    protected abstract String addTopGameFeatures(JButton var1);

    protected abstract String addMGameFeatures();

    protected abstract String addWGameFeatures();

    protected abstract String addIGameFeatures();

    public void setDecomposition(int[] decomposition, int num) {
        this.setDecomposition(decomposition);
        this.myLemma.setDecomposition(decomposition, num);
    }

    public abstract void setDecomposition(int[] var1);

    protected abstract void setCanvas();

    protected abstract String createXYZ();

    public void displayIEnd() {
        this.myIDisplay.setText(Integer.toString(this.myLemma.getI()));
        this.displayEnd();
    }

    public abstract void displayEnd();

    private void stepAnimation() {
        this.repaint();
    }

    public static String toHTMLString(String s) {
        if (s.length() < 2) {
            return s;
        }
        int count = 1;
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            int j = i + 1;
            while (j < s.length()) {
                if (s.substring(j, j + 1).equals(s.substring(i, i + 1))) {
                    ++count;
                } else {
                    ret.append("<i>");
                    ret.append(s.substring(i, i + 1));
                    ret.append("</i>");
                    if (count > 1) {
                        ret.append("<sup>");
                        ret.append("" + count);
                        ret.append("</sup>");
                    }
                    i = j;
                    count = 1;
                }
                if (j == s.length() - 1) {
                    ret.append("<i>");
                    ret.append(s.substring(s.length() - 1));
                    ret.append("</i>");
                    if (count > 1) {
                        ret.append("<sup>");
                        ret.append("" + count);
                        ret.append("</sup>");
                    }
                    return ret.toString();
                }
                ++j;
            }
            ++i;
        }
        System.err.println("BUG FOUND: PumpingLemmaInputPane.toHTMLString(String)");
        System.err.println("String = " + s);
        return ret.toString();
    }

    public abstract void update();
}

