/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.SliderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pumping.PumpingLemma;

public abstract class HumanFirstPane
extends PumpingLemmaInputPane {
    private static final long serialVersionUID = 1L;
    private static String OBJECTIVE = "Find a valid partition that can be pumped.";
    private static String PROMPT_M = "Please select a value for m in Box 1 and press \"Enter\".";
    private static String DESCRIBE_W = "I have selected w such that |w| >= m. It is displayed in Box 2.";
    private static String PROMPT_DECOMPOSITION = "Please select the decomposition of w in Box 3 using the sliders.";
    private static String DESCRIBE_I = "I have selected i to give a contradition. It is displayed in Box 4.";
    protected String decompButtonTitle;
    protected SliderPanel myXPanel;
    protected SliderPanel myYPanel;
    protected JButton myDecompButton;
    protected JTextArea myZDisplay;
    protected JTextArea myZLength;
    protected JTable myXYZDisplay;
    protected JPanel myXYZPanel;
    protected JPanel sliderPanel;

    public HumanFirstPane(PumpingLemma l, String title) {
        super(l, title);
        l.setFirstPlayer("Human");
    }

    @Override
    protected JPanel initDecompPanel() {
        JPanel n = new JPanel(new BorderLayout());
        JPanel o = new JPanel();
        o.setLayout(new BoxLayout(o, 0));
        this.sliderPanel = new JPanel();
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
        this.addDecompPanelGameFeatures(n);
        this.myXPanel = new SliderPanel("x", this);
        this.sliderPanel.add(this.myXPanel);
        this.myYPanel = new SliderPanel("y", this);
        this.sliderPanel.add(this.myYPanel);
        JPanel m = new JPanel();
        m.setLayout(new BoxLayout(m, 0));
        m.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 7));
        m.add(new JLabel("z: "));
        this.myZDisplay = new JTextArea(1, 30);
        this.myZDisplay.setEditable(false);
        m.add(this.myZDisplay);
        m.add(new JLabel("    |z|: "));
        this.myZLength = new JTextArea(1, 5);
        this.myZLength.setEditable(false);
        m.add(this.myZLength);
        this.sliderPanel.add(m);
        this.myXYZPanel = new JPanel(new BorderLayout());
        this.myXYZDisplay = new JTable(1, 1);
        this.myXYZDisplay.setEnabled(false);
        this.myXYZPanel.add(this.myXYZDisplay);
        this.myXYZPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        this.sliderPanel.add((Component)this.myXYZPanel, "South");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.stageMessages[3], "West");
        this.sliderPanel.add(p);
        o.add(this.sliderPanel);
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 1));
        this.myDecompButton = new JButton(this.decompButtonTitle);
        this.myDecompButton.setEnabled(false);
        this.myDecompButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HumanFirstPane.this.stages[4].setVisible(true);
                HumanFirstPane.this.stages[5].setVisible(true);
                HumanFirstPane.this.resetMessages();
                HumanFirstPane.this.setI();
                HumanFirstPane.this.displayIEnd();
                if (HumanFirstPane.this.myLemma.isInLang(HumanFirstPane.this.myLemma.createPumpedString())) {
                    HumanFirstPane.this.myLemma.addAttempt(String.valueOf(HumanFirstPane.this.myLemma.getDecompositionAsString()) + "; I = " + HumanFirstPane.this.myLemma.getI() + "; <i>Won</i>");
                } else {
                    HumanFirstPane.this.myLemma.addAttempt(String.valueOf(HumanFirstPane.this.myLemma.getDecompositionAsString()) + "; I = " + HumanFirstPane.this.myLemma.getI() + "; <i>Failed</i>");
                }
                HumanFirstPane.this.updateTopPane(false);
                HumanFirstPane.this.leftPanel.revalidate();
                HumanFirstPane.this.setCanvas();
                HumanFirstPane.this.myCanvas.stop();
                if (HumanFirstPane.this.myCases != null) {
                    HumanFirstPane.this.myCases.setAddReplaceButtonsEnabled(true);
                }
            }
        });
        q.add(this.myDecompButton);
        o.add(q);
        n.add((Component)o, "North");
        return n;
    }

    public void updateTable() {
        this.myXYZPanel.remove(this.myXYZDisplay);
        this.myXYZDisplay = new JTable(1, this.myLemma.getW().length());
        this.myXYZDisplay.setEnabled(false);
        String s = this.myLemma.getW();
        int i = 0;
        while (i < s.length()) {
            this.myXYZDisplay.setValueAt(s.substring(i, i + 1), 0, i);
            ++i;
        }
        this.myXYZPanel.add((Component)this.myXYZDisplay, "Center");
    }

    @Override
    protected String addTopGameFeatures(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HumanFirstPane.this.myMDisplay.setText("");
                HumanFirstPane.this.updateTopPane(false);
                HumanFirstPane.this.reset();
            }
        });
        return OBJECTIVE;
    }

    @Override
    protected String addMGameFeatures() {
        this.myMDisplay = new JTextField(10);
        ((JTextField)this.myMDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    HumanFirstPane.this.reset();
                    int m = Integer.parseInt(ev.getActionCommand());
                    if (m < HumanFirstPane.this.myLemma.getRange()[0] || m > HumanFirstPane.this.myLemma.getRange()[1]) {
                        throw new NumberFormatException();
                    }
                    HumanFirstPane.this.myLemma.setM(m);
                    HumanFirstPane.this.stages[2].setVisible(true);
                    HumanFirstPane.this.stages[3].setVisible(true);
                    HumanFirstPane.this.mEnteredReset();
                    if (HumanFirstPane.this.myCases != null) {
                        HumanFirstPane.this.myCases.setListButtonEnabled(true);
                    }
                }
                catch (NumberFormatException e) {
                    String error = "Please enter a positive integer in range [" + HumanFirstPane.this.myLemma.getRange()[0] + ", " + HumanFirstPane.this.myLemma.getRange()[1] + "] for best results.";
                    HumanFirstPane.this.myMDisplay.selectAll();
                    HumanFirstPane.this.stageMessages[1].setText(error);
                }
            }
        });
        return new String(PROMPT_M);
    }

    @Override
    protected String addWGameFeatures() {
        this.myWDisplay = new JTextArea(1, 20);
        this.myWDisplay.setEditable(false);
        return new String(DESCRIBE_W);
    }

    protected abstract void addDecompPanelGameFeatures(JPanel var1);

    @Override
    protected String addIGameFeatures() {
        this.myIDisplay = new JTextArea(1, 5);
        this.myIDisplay.setEditable(false);
        return new String(DESCRIBE_I);
    }

    @Override
    public void displayEnd() {
        String s = this.myLemma.createPumpedString();
        this.myPumpedStringDisplay.setText(s);
        if (this.myLemma.isInLang(s)) {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is in the language.  YOU WIN!");
        } else {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is NOT in the language.  Please try again.");
        }
    }

    protected abstract void mEnteredReset();

    protected abstract void refresh();

    protected abstract void setI();
}

