/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pumping.PumpingLemma;

public abstract class ComputerFirstPane
extends PumpingLemmaInputPane {
    private static final long serialVersionUID = 1L;
    private static String OBJECTIVE = "Prevent the computer from finding a valid partition.";
    private static String DESCRIBE_M = "I have selected a value for m, displayed below.";
    private static String PROMPT_W = "Please enter a possible value for w and press \"Enter\".";
    private static String DESCRIBE_DECOMPOSITION = "I have decomposed w into the following...";
    private static String PROMPT_I = "Please enter a possible value for i and press \"Enter\".";
    protected JLabel decompLabel;

    public ComputerFirstPane(PumpingLemma l, String title) {
        super(l, title);
        l.setFirstPlayer("Computer");
    }

    @Override
    protected JPanel initDecompPanel() {
        JPanel p = new JPanel();
        this.decompLabel = new JLabel();
        p.add(this.decompLabel);
        p.setBorder(BorderFactory.createTitledBorder("3. " + DESCRIBE_DECOMPOSITION));
        p.setMaximumSize(new Dimension(ComputerFirstPane.MAX_SIZE.width, ComputerFirstPane.MAX_SIZE.height / 5));
        p.setPreferredSize(new Dimension(ComputerFirstPane.MAX_SIZE.width, ComputerFirstPane.MAX_SIZE.height / 5));
        return p;
    }

    @Override
    public void resetDecompPanel() {
        this.decompLabel.setText("");
    }

    @Override
    public void setDecomposition(int[] decomposition) {
        this.myLemma.setDecomposition(decomposition);
        this.decompLabel.setText(this.myLemma.getDecompositionAsString());
    }

    @Override
    protected String addTopGameFeatures(JButton b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComputerFirstPane.this.myWDisplay.setText("");
                ComputerFirstPane.this.updateTopPane(false);
                ComputerFirstPane.this.reset();
                ComputerFirstPane.this.myLemma.chooseM();
                ComputerFirstPane.this.myMDisplay.setText(Integer.toString(ComputerFirstPane.this.myLemma.getM()));
            }
        });
        return OBJECTIVE;
    }

    @Override
    protected String addMGameFeatures() {
        this.myMDisplay = new JTextArea(1, 10);
        this.myMDisplay.setEditable(false);
        if (this.myLemma.getM() == -1) {
            this.myLemma.chooseM();
        }
        this.myMDisplay.setText(Integer.toString(this.myLemma.getM()));
        return DESCRIBE_M;
    }

    @Override
    protected String addWGameFeatures() {
        this.myWDisplay = new JTextField(20);
        ((JTextField)this.myWDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int i = 3;
                while (i < ComputerFirstPane.this.stages.length) {
                    ComputerFirstPane.this.stages[i].setVisible(false);
                    ++i;
                }
                String w = ComputerFirstPane.this.myWDisplay.getText();
                if (ComputerFirstPane.this.myLemma.isInLang(w) && w.length() >= ComputerFirstPane.this.myLemma.getM()) {
                    ComputerFirstPane.this.myLemma.setW(w);
                    ComputerFirstPane.this.stages[3].setVisible(true);
                    ComputerFirstPane.this.stages[4].setVisible(true);
                    ComputerFirstPane.this.myIDisplay.setText("");
                    ComputerFirstPane.this.myPumpedStringDisplay.setText("");
                    ComputerFirstPane.this.myLemma.chooseDecomposition();
                    ComputerFirstPane.this.decompLabel.setText("\n\n" + ComputerFirstPane.this.myLemma.getDecompositionAsString());
                    ComputerFirstPane.this.resetMessages();
                    ComputerFirstPane.this.leftPanel.revalidate();
                } else {
                    String error = w.length() >= ComputerFirstPane.this.myLemma.getM() ? "That string was not in the language.  Please enter another." : "Remember |w| must be >= m";
                    ComputerFirstPane.this.myWDisplay.selectAll();
                    ComputerFirstPane.this.stageMessages[2].setText(error);
                }
            }
        });
        return PROMPT_W;
    }

    @Override
    protected String addIGameFeatures() {
        this.myIDisplay = new JTextField(20);
        ((JTextField)this.myIDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    int i = Integer.parseInt(ComputerFirstPane.this.myIDisplay.getText());
                    if (i < 0 || i == 1 || i > 12) {
                        throw new NumberFormatException();
                    }
                    ComputerFirstPane.this.stages[5].setVisible(true);
                    ComputerFirstPane.this.myLemma.setI(i);
                    if (ComputerFirstPane.this.myLemma.isInLang(ComputerFirstPane.this.myLemma.createPumpedString())) {
                        ComputerFirstPane.this.myLemma.addAttempt(String.valueOf(ComputerFirstPane.this.myLemma.getDecompositionAsString()) + "; I = " + ComputerFirstPane.this.myLemma.getI() + "; <i>Failed</i>");
                    } else {
                        ComputerFirstPane.this.myLemma.addAttempt(String.valueOf(ComputerFirstPane.this.myLemma.getDecompositionAsString()) + "; I = " + ComputerFirstPane.this.myLemma.getI() + "; <i>Won</i>");
                    }
                    ComputerFirstPane.this.resetMessages();
                    ComputerFirstPane.this.displayEnd();
                    ComputerFirstPane.this.updateTopPane(false);
                    ComputerFirstPane.this.leftPanel.revalidate();
                    ComputerFirstPane.this.setCanvas();
                    ComputerFirstPane.this.myCanvas.stop();
                    if (ComputerFirstPane.this.myCases != null) {
                        ComputerFirstPane.this.myCases.setI(i);
                        ComputerFirstPane.this.myCases.setAddReplaceButtonsEnabled(true);
                    }
                }
                catch (NumberFormatException e) {
                    String error = "Please enter a positive integer in range [0, 2...12] for best results.";
                    ComputerFirstPane.this.myIDisplay.selectAll();
                    ComputerFirstPane.this.stageMessages[4].setText(error);
                }
            }
        });
        return PROMPT_I;
    }

    @Override
    public void displayEnd() {
        String s = this.myLemma.createPumpedString();
        this.myPumpedStringDisplay.setText(s);
        if (this.myLemma.isInLang(s)) {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is in the language.  Please try again.");
        } else {
            this.myLastWord.setText(String.valueOf(this.createXYZ()) + " = " + PumpingLemmaInputPane.toHTMLString(s) + " = " + s + " is NOT in the language.  YOU WIN!");
        }
    }
}

