/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.ComputerFirstPane;
import pumping.RegularPumpingLemma;

public class CompRegPumpingLemmaInputPane
extends ComputerFirstPane {
    private static final long serialVersionUID = 1L;

    public CompRegPumpingLemmaInputPane(RegularPumpingLemma l) {
        super(l, "<i>L</i> = {" + l.getHTMLTitle() + "} Regular Pumping Lemma");
    }

    @Override
    protected void setCanvas() {
        this.stages[5].setVisible(true);
        this.myCanvas.reset();
        this.myCanvas.addText("w =");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getX(), "x");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getY(), "y");
        this.myCanvas.addText(((RegularPumpingLemma)this.myLemma).getZ(), "z");
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = this.myLemma.getI();
        nArray[3] = 1;
        this.myCanvas.moveText(nArray);
        this.myStepAnimation.setEnabled(true);
        this.myStartAnimation.setEnabled(false);
        this.repaint();
    }

    @Override
    protected String createXYZ() {
        return "<i>xy</i><sup>" + this.myLemma.getI() + "</sup><i>z</i>";
    }

    @Override
    public void update() {
        RegularPumpingLemma pl = (RegularPumpingLemma)this.myLemma;
        this.stageMessages[0].setText("File loaded.");
        this.updateTopPane(false);
        int[] decomp = pl.getDecomposition();
        if (decomp[0] == 0 && decomp[1] == 0) {
            return;
        }
        this.myWDisplay.setText(pl.getW());
        this.setDecomposition(new int[]{pl.getX().length(), pl.getY().length()}, pl.getI());
        this.decompLabel.setText(this.myLemma.getDecompositionAsString());
        this.stages[3].setVisible(true);
        this.stages[4].setVisible(true);
        if (pl.getI() == -1) {
            return;
        }
        this.stages[5].setVisible(true);
        this.displayIEnd();
        this.myCanvas.setRestartEnabled(true);
        this.stageMessages[5].setText("Click \"Restart\" to restart the animation.");
        this.stageMessages[5].setVisible(true);
    }
}

