/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pumping.Case;
import pumping.PumpingLemma;

public class CasePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Dimension PREFERRED_SIZE = new Dimension(350, 480);
    private ArrayList<String> myCases;
    private JTable myTable;
    private PumpingLemma myLemma;
    private int[] tempDecomposition;
    private int tempI;
    private JTextArea myMessage;
    private PumpingLemmaInputPane myPane;
    private JButton myShowAll;
    private JButton myClearAll;
    private JButton myClearCase;
    private JButton myShowCase;
    private JButton myAddCase;
    private JButton myDone;
    private JButton myReplace;

    public CasePanel(PumpingLemma l, PumpingLemmaInputPane p) {
        this.myPane = p;
        this.myLemma = l;
        this.myCases = new ArrayList();
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Cases:"), "North");
        this.add((Component)this.initTable(), "Center");
        this.add((Component)this.initButtons(), "South");
        this.setPreferredSize(PREFERRED_SIZE);
        this.refresh();
    }

    protected JComponent initTable() {
        this.myTable = new JTable(new AbstractTableModel(){
            private static final long serialVersionUID = 1L;
            public final String[] COLUMN_NAMES = new String[]{"#", "Description"};

            @Override
            public Object getValueAt(int r, int c) {
                if (c == 0) {
                    return Integer.toString(r + 1);
                }
                return CasePanel.this.myCases.get(r);
            }

            @Override
            public String getColumnName(int c) {
                return this.COLUMN_NAMES[c];
            }

            @Override
            public int getRowCount() {
                return CasePanel.this.myCases.size();
            }

            @Override
            public int getColumnCount() {
                return this.COLUMN_NAMES.length;
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int r, int c) {
            }
        });
        ListSelectionModel m = this.myTable.getSelectionModel();
        m.setSelectionMode(0);
        TableColumn c = this.myTable.getColumnModel().getColumn(0);
        c.setMaxWidth(25);
        JScrollPane p = new JScrollPane(this.myTable);
        return p;
    }

    protected JComponent initButtons() {
        JPanel q = new JPanel();
        q.setLayout(new BoxLayout(q, 1));
        this.myMessage = new JTextArea();
        this.myMessage.setEditable(false);
        q.add(this.myMessage);
        JPanel topRow = new JPanel();
        JPanel bottomRow = new JPanel();
        this.myAddCase = new JButton("Add");
        this.myAddCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.addCase();
            }
        });
        this.myAddCase.setToolTipText("Add the current case to the list");
        this.myAddCase.setEnabled(false);
        topRow.add(this.myAddCase);
        this.myReplace = new JButton("Replace");
        this.myReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.replaceCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myReplace.setToolTipText("Replace the selected case with the current case");
        this.myReplace.setEnabled(false);
        topRow.add(this.myReplace);
        this.myShowAll = new JButton("List");
        this.myShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.listAll();
            }
        });
        this.myShowAll.setEnabled(false);
        this.myShowAll.setToolTipText("List all possible cases");
        bottomRow.add(this.myShowAll);
        this.myShowCase = new JButton("Show");
        this.myShowCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.showCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myShowCase.setEnabled(false);
        this.myShowCase.setToolTipText("Display the selected case");
        topRow.add(this.myShowCase);
        this.myClearCase = new JButton("Delete");
        this.myClearCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.clearCase(CasePanel.this.myTable.getSelectedRow());
            }
        });
        this.myClearCase.setEnabled(false);
        this.myClearCase.setToolTipText("Delete the selected case");
        topRow.add(this.myClearCase);
        this.myClearAll = new JButton("Clear");
        this.myClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CasePanel.this.clearAll();
            }
        });
        this.myClearAll.setToolTipText("Clear all cases");
        bottomRow.add(this.myClearAll);
        this.myDone = new JButton("Done?");
        this.myDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numLeft = CasePanel.this.myLemma.numCasesTotal() - CasePanel.this.myCases.size();
                if (numLeft == 1) {
                    CasePanel.this.myMessage.setText("1 case left.");
                } else if (numLeft > 1) {
                    CasePanel.this.myMessage.setText(String.valueOf(numLeft) + " cases left.");
                } else {
                    CasePanel.this.myMessage.setText("All cases done.");
                }
            }
        });
        this.myDone.setToolTipText("Check if all cases are done");
        bottomRow.add(this.myDone);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    CasePanel.this.myShowCase.setEnabled(false);
                    CasePanel.this.myClearCase.setEnabled(false);
                    CasePanel.this.myReplace.setEnabled(false);
                } else {
                    CasePanel.this.myShowCase.setEnabled(true);
                    CasePanel.this.myClearCase.setEnabled(true);
                    CasePanel.this.myReplace.setEnabled(CasePanel.this.myAddCase.isEnabled());
                }
            }
        });
        q.add(topRow);
        q.add(bottomRow);
        JScrollPane r = new JScrollPane(q);
        return r;
    }

    protected void listAll() {
        if (this.myCases.size() == this.myLemma.numCasesTotal()) {
            this.myMessage.setText("All cases for m = " + this.myLemma.getM() + " are already shown.");
        } else {
            this.myLemma.doAll();
            this.myMessage.setText("All cases for m = " + this.myLemma.getM() + " shown.");
            this.refresh();
        }
    }

    public void clearAll() {
        this.myLemma.clearDoneCases();
        this.myMessage.setText("All cases cleared.");
        this.refresh();
    }

    protected void clearCase(int i) {
        try {
            this.myLemma.clearCase(i);
            this.myCases.remove(i);
            this.myMessage.setText("Case #" + (i + 1) + " deleted.");
            this.refresh();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.myMessage.setText("Please select a case to clear.");
        }
    }

    protected void showCase(int i) {
        try {
            Case c = this.myLemma.getCase(i);
            if (c.getI() != -1) {
                this.myPane.setDecomposition(c.getInput(), c.getI());
                this.myPane.displayIEnd();
                this.myPane.setVisibilityStages(4, true);
                this.myPane.setCanvas();
                this.setAddReplaceButtonsEnabled(true);
            } else {
                this.myPane.setDecomposition(c.getInput());
                this.myPane.setVisibilityStages(4, false);
                this.setAddReplaceButtonsEnabled(false);
            }
            this.refresh();
            this.myTable.getSelectionModel().setSelectionInterval(i, i);
            this.myMessage.setText("Showing case #" + (i + 1) + ".");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.myMessage.setText("Please select a case to show.");
        }
    }

    protected void setDecomposition(int[] decomposition) {
        this.tempDecomposition = decomposition;
    }

    protected void setI(int i) {
        this.tempI = i;
    }

    protected void addCase() {
        this.addCase(this.tempDecomposition, this.tempI);
    }

    protected void replaceCase(int index) {
        if (this.myLemma.replaceCase(this.tempDecomposition, this.tempI, index)) {
            this.myMessage.setText("Case #" + (index + 1) + " replaced.");
        } else {
            this.myMessage.setText("Wrong case selected.");
        }
    }

    protected void addCase(int[] decomposition, int i) {
        int ret = this.myLemma.addCase(decomposition, i);
        this.refresh();
        if (ret == -1) {
            this.myMessage.setText("Illegal decomposition!");
            return;
        }
        if (ret >= this.myCases.size()) {
            ret = this.myCases.size() - 1;
            this.myMessage.setText("Case added.");
        } else {
            this.myMessage.setText("This case is similar to #" + (ret + 1) + ".");
        }
        this.myTable.getSelectionModel().setSelectionInterval(ret, ret);
    }

    public void refresh() {
        this.myCases = this.myLemma.getDoneDescriptions();
        ((AbstractTableModel)this.myTable.getModel()).fireTableDataChanged();
        if (this.myCases.size() == 0) {
            this.myDone.setEnabled(false);
            this.myClearAll.setEnabled(false);
        } else {
            this.myDone.setEnabled(true);
            this.myClearAll.setEnabled(true);
        }
        this.repaint();
    }

    public void setListButtonEnabled(boolean b) {
        this.myShowAll.setEnabled(b);
    }

    public void setAddReplaceButtonsEnabled(boolean b) {
        this.myAddCase.setEnabled(b);
        if (this.myShowCase.isEnabled()) {
            this.myReplace.setEnabled(b);
        }
    }

    protected void setMessage(String message) {
        this.myMessage.setText(message);
    }
}

