/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import automata.fsa.Minimizer;
import automata.graph.AutomatonGraph;
import automata.graph.layout.GEMLayoutAlgorithm;
import gui.SplitPaneFactory;
import gui.SuperMouseAdapter;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.Environment;
import gui.minimize.BuilderControlPanel;
import gui.minimize.BuilderController;
import gui.minimize.ControlPanel;
import gui.minimize.MinimizeController;
import gui.minimize.MinimizeNodeDrawer;
import gui.tree.SelectTreeDrawer;
import gui.tree.TreePanel;
import gui.tree.Trees;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class MinimizePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    Minimizer minimizer;
    SelectionDrawer automatonDrawer;
    SelectTreeDrawer treeDrawer;
    MinimizeController controller;
    BuilderController builderController = null;
    JSplitPane split;
    ControlPanel controlPanel;
    JLabel messageLabel = new JLabel(" ");

    public MinimizePane(FiniteStateAutomaton dfa, Environment environment) {
        this.minimizer = new Minimizer();
        this.minimizer.initializeMinimizer();
        dfa = (FiniteStateAutomaton)this.minimizer.getMinimizeableAutomaton(dfa);
        DefaultTreeModel tree = this.minimizer.getInitializedTree(dfa);
        this.automatonDrawer = new SelectionDrawer(dfa);
        this.treeDrawer = new SelectTreeDrawer(tree);
        MinimizeNodeDrawer nodeDrawer = new MinimizeNodeDrawer();
        this.treeDrawer.setNodeDrawer(nodeDrawer);
        TreeNode[] groups = Trees.children((MinimizeTreeNode)tree.getRoot());
        int i = 0;
        while (i < groups.length) {
            MinimizeTreeNode group = (MinimizeTreeNode)groups[i];
            State[] states = (State[])group.getUserObject();
            if (states.length != 0) {
                if (dfa.isFinalState(states[0])) {
                    nodeDrawer.setLabel(group, "Final");
                } else {
                    nodeDrawer.setLabel(group, "Nonfinal");
                }
            }
            ++i;
        }
        this.controller = new MinimizeController(this, this.automatonDrawer, this.treeDrawer, this.minimizer);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.initTreePane(), "Center");
        this.controlPanel = new ControlPanel(this.treeDrawer, this.controller);
        this.split = SplitPaneFactory.createSplit(environment, true, 0.5, this.initAutomatonPane(), right);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.messageLabel, "South");
        this.split.setResizeWeight(0.5);
        this.controller.setEnabledness();
    }

    public AutomatonPane initAutomatonPane() {
        AutomatonPane apane = new AutomatonPane(this.automatonDrawer);
        ArrowMinimizeTool a = new ArrowMinimizeTool(apane, this.automatonDrawer);
        apane.addMouseListener(a);
        apane.addMouseMotionListener(a);
        return apane;
    }

    public TreePanel initTreePane() {
        final TreePanel tpane = new TreePanel(this.treeDrawer);
        SuperMouseAdapter a = new SuperMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreeNode n = tpane.nodeAtPoint(event.getPoint());
                MinimizePane.this.controller.nodeClicked((MinimizeTreeNode)n, event);
            }

            @Override
            public void mousePressed(MouseEvent event) {
                TreeNode n = tpane.nodeAtPoint(event.getPoint());
                MinimizePane.this.controller.nodeDown((MinimizeTreeNode)n, event);
            }
        };
        tpane.addMouseListener(a);
        tpane.addMouseMotionListener(a);
        return tpane;
    }

    public void beginMinimizedAutomaton(FiniteStateAutomaton dfa, DefaultTreeModel tree) {
        this.remove(this.controlPanel);
        FiniteStateAutomaton newAutomaton = new FiniteStateAutomaton();
        this.minimizer.createStatesForMinimumDfa(dfa, newAutomaton, tree);
        SelectionDrawer drawer = new SelectionDrawer(newAutomaton);
        EditorPane ep = new EditorPane(drawer, new ToolBox(){

            @Override
            public List<Tool> tools(AutomatonPane view, AutomatonDrawer drawer) {
                LinkedList<Tool> tools = new LinkedList<Tool>();
                tools.add(new ArrowMinimizeTool(view, drawer));
                tools.add(new TransitionTool(view, drawer));
                return tools;
            }
        });
        this.automatonDrawer.clearSelected();
        this.builderController = new BuilderController(dfa, newAutomaton, drawer, this.minimizer, tree, this.split);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)ep, "Center");
        ep.getToolBar().addSeparator();
        BuilderControlPanel.initView(ep.getToolBar(), this.builderController);
        this.split.setRightComponent(right);
        this.invalidate();
        this.repaint();
        AutomatonGraph graph = new AutomatonGraph(newAutomaton);
        graph.addVertex(newAutomaton.getInitialState(), new Point(0, 0));
        for (Transition transition : this.builderController.remainingTransitions) {
            graph.addEdge(transition.getFromState(), transition.getToState());
        }
        GEMLayoutAlgorithm gEMLayoutAlgorithm = new GEMLayoutAlgorithm();
        HashSet<Object> constantStates = new HashSet<Object>();
        constantStates.add(newAutomaton.getInitialState());
        gEMLayoutAlgorithm.layout(graph, constantStates);
        graph.moveAutomatonStates();
        this.validate();
        ep.getAutomatonPane().fitToBounds(10);
    }

    private class ArrowMinimizeTool
    extends ArrowNontransitionTool {
        public ArrowMinimizeTool(AutomatonPane view, AutomatonDrawer drawer) {
            super(view, drawer);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            super.mouseClicked(event);
            State s = MinimizePane.this.automatonDrawer.stateAtPoint(event.getPoint());
            if (MinimizePane.this.builderController == null) {
                MinimizePane.this.controller.stateDown(s, event);
            }
        }
    }
}

