/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.fsa.MinimizeTreeNode;
import gui.TooltipAction;
import gui.minimize.MinimizeController;
import gui.tree.SelectTreeDrawer;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;

class ControlPanel
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private SelectTreeDrawer treeDrawer;
    private MinimizeController controller;
    private static final String NODE_ERROR = "Exactly one node must be selected!";
    TooltipAction setTerminalAction;
    TooltipAction autoPartitionAction;
    TooltipAction completeSubtreeAction;
    TooltipAction checkNodeAction;
    TooltipAction addChildAction;
    TooltipAction removeAction;
    TooltipAction finishAction;

    public ControlPanel(SelectTreeDrawer treeDrawer, MinimizeController controller) {
        this.treeDrawer = treeDrawer;
        this.controller = controller;
        this.initView();
    }

    private MinimizeTreeNode getNode() {
        TreeNode[] selected = this.treeDrawer.getSelected();
        if (selected.length != 1) {
            return null;
        }
        return (MinimizeTreeNode)selected[0];
    }

    private void initView() {
        this.setTerminalAction = new TooltipAction("Set Terminal", "Begins the split of a group on a terminal."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MinimizeTreeNode node = ControlPanel.this.getNode();
                if (node == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitOnTerminal(node);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.setTerminalAction);
        this.autoPartitionAction = new TooltipAction("Auto Partition", "Does the split of a group for you."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MinimizeTreeNode node = ControlPanel.this.getNode();
                if (node == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitWithoutInput(node);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.autoPartitionAction);
        this.completeSubtreeAction = new TooltipAction("Complete Subtree", "Does the split of this group and any subgroups for you."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MinimizeTreeNode node = ControlPanel.this.getNode();
                if (node == null) {
                    JOptionPane.showMessageDialog(ControlPanel.this, ControlPanel.NODE_ERROR);
                    return;
                }
                ControlPanel.this.controller.splitSubtree(node);
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.completeSubtreeAction);
        this.checkNodeAction = new TooltipAction("Check Node", "Verifies that a split of a group is correct."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ControlPanel.this.controller.check();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.checkNodeAction);
        this.addChildAction = new TooltipAction("Add Child", "Adds a new partition a group being split."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ControlPanel.this.controller.addChild();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.addChildAction);
        this.removeAction = new TooltipAction("Remove", "Removes a partition from a group being split."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                TreeNode[] selected = ControlPanel.this.treeDrawer.getSelected();
                int i = 0;
                while (i < selected.length) {
                    ControlPanel.this.controller.removeNode((MinimizeTreeNode)selected[i]);
                    ++i;
                }
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.removeAction);
        this.finishAction = new TooltipAction("Finish", "If the tree is done, begins building the automaton."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                ControlPanel.this.controller.finished();
                ControlPanel.this.controller.setEnabledness();
            }
        };
        this.add(this.finishAction);
    }
}

