/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.Minimizer;
import gui.environment.FrameFactory;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

class BuilderController {
    private FiniteStateAutomaton dfa;
    private FiniteStateAutomaton minDfa;
    private SelectionDrawer drawer;
    private Minimizer minimizer;
    private DefaultTreeModel tree;
    private Component view;
    Set<Object> remainingTransitions;

    public BuilderController(FiniteStateAutomaton dfa, FiniteStateAutomaton minDfa, SelectionDrawer drawer, Minimizer minimizer, DefaultTreeModel tree, Component view) {
        this.dfa = dfa;
        this.minDfa = minDfa;
        this.drawer = drawer;
        this.minimizer = minimizer;
        this.tree = tree;
        this.view = view;
        this.determineTransitions();
        this.initTransitionListener();
    }

    private void determineTransitions() {
        this.remainingTransitions = new HashSet<Object>();
        State[] states = this.minDfa.getStates();
        int i = 0;
        while (i < states.length) {
            this.remainingTransitions.addAll(this.minimizer.getTransitionsForState(states[i], this.minDfa, this.dfa, this.tree));
            ++i;
        }
    }

    private void initTransitionListener() {
        this.minDfa.addTransitionListener(new AutomataTransitionListener(){

            @Override
            public void automataTransitionChange(AutomataTransitionEvent e) {
                if (!e.isAdd()) {
                    return;
                }
                Transition transition = e.getTransition();
                if (!BuilderController.this.remainingTransitions.contains(transition)) {
                    JOptionPane.showMessageDialog(BuilderController.this.view, "That transition is not correct!");
                    BuilderController.this.minDfa.removeTransition(transition);
                } else {
                    BuilderController.this.remainingTransitions.remove(transition);
                }
            }
        });
    }

    public void hint() {
        if (this.remainingTransitions.size() == 0) {
            JOptionPane.showMessageDialog(this.view, "All transitions are in place already!");
            return;
        }
        Iterator<Object> it = new HashSet<Object>(this.remainingTransitions).iterator();
        Transition t = (Transition)it.next();
        this.minDfa.addTransition(t);
    }

    public void complete() {
        if (this.remainingTransitions.size() == 0) {
            JOptionPane.showMessageDialog(this.view, "All transitions are in place already!");
            return;
        }
        for (Transition transition : new HashSet<Object>(this.remainingTransitions)) {
            this.minDfa.addTransition(transition);
        }
    }

    public void done() {
        int remain = this.remainingTransitions.size();
        if (remain != 0) {
            Transition t = (Transition)this.remainingTransitions.iterator().next();
            this.drawer.addSelected(t.getFromState());
            JOptionPane.showMessageDialog(this.view, String.valueOf(remain) + " transition" + (remain == 1 ? "" : "s") + " remain " + "to be placed.\n" + "One comes from the state highlighted.");
            this.drawer.clearSelected();
            return;
        }
        JOptionPane.showMessageDialog(this.view, "The minimized automaton is fully built!\nIt will now be placed in a new window.");
        FrameFactory.createFrame((FiniteStateAutomaton)this.minDfa.clone());
    }
}

