/*
 * Decompiled with CFR 0.152.
 */
package gui.menu;

import automata.Automaton;
import automata.fsa.FiniteStateAutomaton;
import grammar.TuringChecker;
import gui.action.AboutAction;
import gui.action.AddTrapStateToDFAAction;
import gui.action.AutomatonAction;
import gui.action.BruteParseAction;
import gui.action.BuildingBlockSimulateAction;
import gui.action.CYKParseAction;
import gui.action.CloseAction;
import gui.action.CloseButton;
import gui.action.CloseWindowAction;
import gui.action.CombineAutomaton;
import gui.action.ConvertCFGLL;
import gui.action.ConvertCFGLR;
import gui.action.ConvertFSAToGrammarAction;
import gui.action.ConvertFSAToREAction;
import gui.action.ConvertPDAToGrammarAction;
import gui.action.ConvertRegularGrammarToFSA;
import gui.action.DFAEqualityAction;
import gui.action.GrammarTransformAction;
import gui.action.GrammarTypeTestAction;
import gui.action.LLParseTableAction;
import gui.action.LRParseTableAction;
import gui.action.LSystemDisplay;
import gui.action.LambdaHighlightAction;
import gui.action.LayoutAlgorithmAction;
import gui.action.LayoutStorageAction;
import gui.action.MinimizeTreeAction;
import gui.action.MultipleBruteParseAction;
import gui.action.MultipleCYKParseAction;
import gui.action.MultipleOutputSimulateAction;
import gui.action.MultipleSimulateAction;
import gui.action.NFAToDFAAction;
import gui.action.NewAction;
import gui.action.NoInteractionSimulateAction;
import gui.action.NondeterminismAction;
import gui.action.OpenAction;
import gui.action.OpenURLAction;
import gui.action.PrintAction;
import gui.action.QuitAction;
import gui.action.REToFSAAction;
import gui.action.RestrictedAction;
import gui.action.SaveAction;
import gui.action.SaveAsAction;
import gui.action.SaveGraphBMPAction;
import gui.action.SaveGraphGIFAction;
import gui.action.SaveGraphJPGAction;
import gui.action.SaveGraphPNGAction;
import gui.action.SimulateAction;
import gui.action.SimulateNoClosureAction;
import gui.action.TuringBruteParseAction;
import gui.action.TuringToUnrestrictGrammarAction;
import gui.action.UserControlParseAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.LSystemEnvironment;
import gui.environment.RegularEnvironment;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class MenuBarCreator {
    public static JMenuBar getMenuBar(EnvironmentFrame frame) {
        JMenuBar bar = new JMenuBar();
        JMenu menu = MenuBarCreator.getFileMenu(frame);
        if (menu.getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getInputMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getTestMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getViewMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getConvertMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getHelpMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        CloseButton dismiss = new CloseButton(frame.getEnvironment());
        bar.add(Box.createGlue());
        bar.add(dismiss);
        return bar;
    }

    public static JMenuBar getMenuBar(EnvironmentFrame frame, int isTuring) {
        JMenuBar bar = new JMenuBar();
        JMenu menu = MenuBarCreator.getFileMenu(frame);
        if (menu.getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getInputMenu(frame, isTuring)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getTestMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getViewMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getConvertMenu(frame, isTuring)).getItemCount() > 0) {
            bar.add(menu);
        }
        if ((menu = MenuBarCreator.getHelpMenu(frame)).getItemCount() > 0) {
            bar.add(menu);
        }
        CloseButton dismiss = new CloseButton(frame.getEnvironment());
        bar.add(Box.createGlue());
        bar.add(dismiss);
        return bar;
    }

    public static void addItem(JMenu menu, Action a) {
        JMenuItem item = new JMenuItem(a);
        item.setAccelerator((KeyStroke)a.getValue("AcceleratorKey"));
        menu.add(item);
    }

    private static JMenu getFileMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("File");
        MenuBarCreator.addItem(menu, new NewAction());
        SecurityManager sm = System.getSecurityManager();
        if (Universe.CHOOSER != null) {
            MenuBarCreator.addItem(menu, new OpenAction());
            MenuBarCreator.addItem(menu, new SaveAction(environment));
            MenuBarCreator.addItem(menu, new SaveAsAction(environment));
            JMenu saveImageMenu = new JMenu("Save Image As...");
            saveImageMenu.add(new SaveGraphJPGAction(environment, menu));
            saveImageMenu.add(new SaveGraphPNGAction(environment, menu));
            saveImageMenu.add(new SaveGraphGIFAction(environment, menu));
            saveImageMenu.add(new SaveGraphBMPAction(environment, menu));
            if (environment instanceof AutomatonEnvironment) {
                JarFile jar = null;
                try {
                    if (new File("JFLAP.jar").exists()) {
                        jar = new JarFile("JFLAP.jar");
                    } else if (new File("JFLAP_With_Source.jar").exists()) {
                        jar = new JarFile("JFLAP_With_Source.jar");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                if (new File("svg.jar").exists() || jar != null && jar.getJarEntry("org/foo.txt") != null) {
                    try {
                        RestrictedAction ra = (RestrictedAction)Class.forName("gui.action.ExportAction").getConstructor(Environment.class).newInstance(environment);
                        saveImageMenu.add(ra);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Cannot make menu");
                    }
                }
            }
            menu.add(saveImageMenu);
        } else {
            MenuBarCreator.addItem(menu, new OpenURLAction());
        }
        MenuBarCreator.addItem(menu, new CloseAction(environment));
        MenuBarCreator.addItem(menu, new CloseWindowAction(frame));
        try {
            if (sm != null) {
                sm.checkPrintJobAccess();
            }
            MenuBarCreator.addItem(menu, new PrintAction(environment));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (sm != null) {
                sm.checkExit(0);
            }
            MenuBarCreator.addItem(menu, new QuitAction());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return menu;
    }

    private static JMenu getInputMenu(EnvironmentFrame frame) {
        boolean isTuring;
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Input");
        Serializable object = environment.getObject();
        if (SimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new SimulateAction((Automaton)object, environment));
        }
        if (BuildingBlockSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new BuildingBlockSimulateAction((Automaton)object, environment));
        }
        if (SimulateNoClosureAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new SimulateNoClosureAction((Automaton)object, environment));
        }
        if (NoInteractionSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NoInteractionSimulateAction((Automaton)object, environment));
        }
        if (MultipleSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleSimulateAction((Automaton)object, environment));
        }
        if (MultipleOutputSimulateAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleOutputSimulateAction((Automaton)object, environment));
        }
        if (isTuring = TuringChecker.check(object)) {
            return MenuBarCreator.getInputMenu(frame, 0);
        }
        if (LLParseTableAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LLParseTableAction((GrammarEnvironment)environment));
        }
        if (LRParseTableAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LRParseTableAction((GrammarEnvironment)environment));
        }
        if (BruteParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new BruteParseAction((GrammarEnvironment)environment));
        }
        if (MultipleBruteParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleBruteParseAction((GrammarEnvironment)environment));
        }
        if (UserControlParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new UserControlParseAction((GrammarEnvironment)environment));
        }
        if (CYKParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new CYKParseAction((GrammarEnvironment)environment));
        }
        if (MultipleCYKParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MultipleCYKParseAction((GrammarEnvironment)environment));
        }
        if (LSystemDisplay.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LSystemDisplay((LSystemEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getInputMenu(EnvironmentFrame frame, int specialCaseForTuringConverted) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Input");
        Serializable object = environment.getObject();
        if (UserControlParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new UserControlParseAction((GrammarEnvironment)environment));
        }
        if (TuringBruteParseAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new TuringBruteParseAction((GrammarEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getViewMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("View");
        Serializable object = environment.getObject();
        if (AutomatonAction.isApplicable(object)) {
            Automaton automaton = (Automaton)object;
            LayoutStorageAction store = new LayoutStorageAction("Save Current Graph Layout", "Restore Saved Graph Layout", automaton);
            menu.add(store);
            menu.add(store.getRestoreAction());
            JMenu viewMenu = new JMenu("Move Vertices");
            JMenu subMenu = new JMenu("Reflect Across Line...");
            subMenu.add(new LayoutAlgorithmAction("Horizontal Line Through Center", automaton, environment, -10));
            subMenu.add(new LayoutAlgorithmAction("Vertical Line Through Center", automaton, environment, -11));
            subMenu.add(new LayoutAlgorithmAction("Diagonal From Upper-Left To Lower-Right", automaton, environment, -12));
            subMenu.add(new LayoutAlgorithmAction("Diagonal From Lower-Left To Upper-Right", automaton, environment, -13));
            viewMenu.add(subMenu);
            viewMenu.add(new LayoutAlgorithmAction("Rotate The Graph", automaton, environment, -14));
            viewMenu.add(new LayoutAlgorithmAction("Fill Screen With Graph", automaton, environment, -15));
            menu.add(viewMenu);
            menu.add(new LayoutAlgorithmAction("Apply A Random Layout Algorithm", automaton, environment, -1));
            viewMenu = new JMenu("Apply A Specific Layout Algorithm");
            viewMenu.add(new LayoutAlgorithmAction("Circle", automaton, environment, 0));
            viewMenu.add(new LayoutAlgorithmAction("GEM", automaton, environment, 1));
            viewMenu.add(new LayoutAlgorithmAction("Random", automaton, environment, 2));
            viewMenu.add(new LayoutAlgorithmAction("Spiral", automaton, environment, 3));
            subMenu = new JMenu("Tree");
            subMenu.add(new LayoutAlgorithmAction("Degree", automaton, environment, 5));
            subMenu.add(new LayoutAlgorithmAction("Hierarchy", automaton, environment, 4));
            viewMenu.add(subMenu);
            viewMenu.add(new LayoutAlgorithmAction("Two Circle", automaton, environment, 6));
            menu.add(viewMenu);
        }
        return menu;
    }

    private static JMenu getTestMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Test");
        Serializable object = environment.getObject();
        if (DFAEqualityAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new DFAEqualityAction((FiniteStateAutomaton)object, environment));
        }
        if (NondeterminismAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NondeterminismAction((Automaton)object, environment));
        }
        if (LambdaHighlightAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new LambdaHighlightAction((Automaton)object, environment));
        }
        if (GrammarTypeTestAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new GrammarTypeTestAction((GrammarEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getConvertMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Convert");
        Serializable object = environment.getObject();
        boolean isTuring = TuringChecker.check(object);
        if (isTuring) {
            return MenuBarCreator.getConvertMenu(frame, 0);
        }
        if (NFAToDFAAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new NFAToDFAAction((FiniteStateAutomaton)object, environment));
        }
        if (MinimizeTreeAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new MinimizeTreeAction((FiniteStateAutomaton)object, environment));
        }
        if (ConvertFSAToGrammarAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertFSAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertPDAToGrammarAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertPDAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertFSAToREAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertFSAToREAction((AutomatonEnvironment)environment));
        }
        if (ConvertCFGLL.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertCFGLL((GrammarEnvironment)environment));
        }
        if (ConvertCFGLR.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertCFGLR((GrammarEnvironment)environment));
        }
        if (ConvertRegularGrammarToFSA.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new ConvertRegularGrammarToFSA((GrammarEnvironment)environment));
        }
        if (GrammarTransformAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new GrammarTransformAction((GrammarEnvironment)environment));
        }
        if (REToFSAAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new REToFSAAction((RegularEnvironment)environment));
        }
        if (CombineAutomaton.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new CombineAutomaton((AutomatonEnvironment)environment));
        }
        if (TuringToUnrestrictGrammarAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new TuringToUnrestrictGrammarAction((AutomatonEnvironment)environment));
        }
        if (AddTrapStateToDFAAction.isApplicable(object)) {
            MenuBarCreator.addItem(menu, new AddTrapStateToDFAAction((AutomatonEnvironment)environment));
        }
        return menu;
    }

    private static JMenu getConvertMenu(EnvironmentFrame frame, int specialCaseForTuringConverted) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Convert");
        Serializable object = environment.getObject();
        return menu;
    }

    private static JMenu getHelpMenu(EnvironmentFrame frame) {
        Environment environment = frame.getEnvironment();
        JMenu menu = new JMenu("Help");
        Serializable object = environment.getObject();
        MenuBarCreator.addItem(menu, new AbstractAction("Help..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(null, "For help, feel free to access the JFLAP tutorial at\n                          www.jflap.org.", "Help", -1);
            }
        });
        MenuBarCreator.addItem(menu, new AboutAction());
        return menu;
    }
}

