/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.Production;
import grammar.UselessProductionRemover;
import gui.grammar.transform.UselessPane;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class UselessController {
    UselessPane pane;
    Grammar grammar;
    UselessProductionRemover remover = new UselessProductionRemover();
    Set<String> terminalVariables;
    Set<String> derivedTerminalVariables = new TreeSet<String>();
    VariableDependencyGraph vdg = new VariableDependencyGraph();
    Set<Transition> vdgTransitions = new HashSet<Transition>();
    Set<Production> currentProductions = new HashSet<Production>();
    Set<Production> uselessProductions = new HashSet<Production>();
    int step = 0;
    static final int DERIVE_TERMINALS = 1;
    static final int VARAIBLE_GRAPH = 2;
    static final int PRODUCTION_MODIFY = 3;
    static final int FINISHED = 4;
    static final int START_NOT_TERMINAL_DERIVING_ERROR = 5;

    public UselessController(UselessPane pane, Grammar grammar) {
        this.pane = pane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step < 4) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Select variables that derive terminals.");
                this.pane.detailLabel.setText("Click productions; the LHS variable will be added.");
                this.terminalVariables = UselessProductionRemover.getCompleteUsefulVariableSet(this.grammar);
                this.pane.deleteAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                this.grammar = UselessProductionRemover.getTerminalGrammar(this.grammar);
                break;
            }
            case 2: {
                if (!this.terminalVariables.contains(this.grammar.getStartVariable())) {
                    this.step = 5;
                    this.nextStep();
                    return;
                }
                this.pane.mainLabel.setText("Complete dependency graph.");
                this.pane.detailLabel.setText("For every production, connect start and end.");
                UselessProductionRemover.initializeVariableDependencyGraph(this.vdg, this.grammar);
                State[] s = this.vdg.getStates();
                int i = 0;
                while (i < s.length) {
                    if (this.terminalVariables.contains(s[i].getName())) {
                        this.vdg.addFinalState(s[i]);
                    }
                    ++i;
                }
                Production[] p = this.grammar.getProductions();
                String[] variables = this.terminalVariables.toArray(new String[0]);
                int i2 = 0;
                while (i2 < variables.length) {
                    int j = 0;
                    while (j < variables.length) {
                        String v1 = variables[i2];
                        String v2 = variables[j];
                        if (i2 != j && UselessProductionRemover.isDependentOn(v1, v2, this.grammar)) {
                            this.vdgTransitions.add(UselessProductionRemover.getTransition(v1, v2, this.vdg));
                        }
                        ++j;
                    }
                    ++i2;
                }
                this.vdg.addTransitionListener(new AutomataTransitionListener(){

                    @Override
                    public void automataTransitionChange(AutomataTransitionEvent e) {
                        if (!e.isAdd()) {
                            return;
                        }
                        if (UselessController.this.vdgTransitions.contains(e.getTransition())) {
                            UselessController.this.vdgTransitions.remove(e.getTransition());
                            UselessController.this.updateDisplay();
                            return;
                        }
                        JOptionPane.showMessageDialog(UselessController.this.pane, "Transition is not part of VDG.", "Bad Transition", 0);
                        UselessController.this.vdg.removeTransition(e.getTransition());
                    }
                });
                i2 = 0;
                while (i2 < p.length) {
                    this.pane.editingGrammarModel.addProduction(p[i2]);
                    this.currentProductions.add(p[i2]);
                    ++i2;
                }
                this.updateDisplay();
                break;
            }
            case 3: {
                this.pane.updateDeleteEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove useless productions.");
                Grammar g = UselessProductionRemover.getUselessProductionlessGrammar(this.grammar);
                Production[] p = this.grammar.getProductions();
                Production[] p2 = g.getProductions();
                HashSet<Production> usefulProductions = new HashSet<Production>(Arrays.asList(p2));
                int i = 0;
                while (i < p.length) {
                    if (!usefulProductions.contains(p[i])) {
                        this.uselessProductions.add(p[i]);
                    }
                    ++i;
                }
                this.updateDisplay();
                break;
            }
            case 4: {
                this.pane.editingActive = false;
                this.pane.deleteAction.setEnabled(false);
                this.pane.mainLabel.setText("Useless removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
                break;
            }
            case 5: {
                this.pane.mainLabel.setText("The start variable " + this.grammar.getStartVariable() + " does not derive terminals.");
                this.pane.detailLabel.setText("The grammar cannot have rules.  No further action is sensible.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
            }
        }
    }

    void doStep() {
        switch (this.step) {
            case 1: {
                this.derivedTerminalVariables.addAll(this.terminalVariables);
                this.pane.terminalLabel.setText("Variables that predicate terminals: " + this.derivedTerminalVariables);
                this.nextStep();
                break;
            }
            case 2: {
                Transition[] t = this.vdgTransitions.toArray(new Transition[0]);
                int i = 0;
                while (i < t.length) {
                    this.vdg.addTransition(t[i]);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = this.pane.editingGrammarModel.getRowCount() - 2;
                while (i >= 0) {
                    Production p = this.pane.editingGrammarModel.getProduction(i);
                    if (this.uselessProductions.contains(p)) {
                        this.pane.editingGrammarModel.deleteRow(i);
                        this.uselessProductions.remove(p);
                    }
                    --i;
                }
                this.updateDisplay();
                break;
            }
        }
    }

    public void doAll() {
        while (this.step != 4) {
            this.doStep();
        }
    }

    public Grammar getGrammar() {
        return this.pane.getGrammar();
    }

    void updateDisplay() {
        switch (this.step) {
            case 2: {
                int toAdd = this.vdgTransitions.size();
                this.pane.detailLabel.setText(String.valueOf(toAdd) + " more transition(s) needed.");
                if (toAdd != 0) break;
                this.nextStep();
                break;
            }
            case 3: {
                int toRemove = this.uselessProductions.size();
                this.pane.detailLabel.setText(String.valueOf(toRemove) + " more remove(s) needed.");
                if (toRemove != 0) break;
                this.nextStep();
            }
        }
    }

    void productionClicked(Production production, MouseEvent event) {
        switch (this.step) {
            case 1: {
                String var = production.getLHS();
                if (this.derivedTerminalVariables.contains(var)) {
                    this.pane.detailLabel.setText(String.valueOf(var) + " already selected!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                    return;
                }
                if (this.terminalVariables.contains(var)) {
                    this.derivedTerminalVariables.add(var);
                    this.pane.detailLabel.setText(String.valueOf(var) + " added!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                    this.pane.terminalLabel.setText("Variables that predicate terminals: " + this.derivedTerminalVariables);
                    if (this.derivedTerminalVariables.size() == this.terminalVariables.size()) {
                        this.nextStep();
                    }
                    return;
                }
                this.pane.detailLabel.setText(String.valueOf(var) + " does not predicate terminals!  " + (this.terminalVariables.size() - this.derivedTerminalVariables.size()) + " more variable(s) needed.");
                break;
            }
        }
    }

    boolean productionDeleted(Production production, int row) {
        return this.uselessProductions.remove(production) && this.currentProductions.remove(production);
    }
}

