/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.Production;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.action.GrammarTransformAction;
import gui.environment.FrameFactory;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.LambdaController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class LambdaPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    GrammarEnvironment environment;
    Grammar grammar;
    LambdaController controller;
    GrammarTable grammarTable;
    JLabel mainLabel = new JLabel(" ");
    JLabel detailLabel = new JLabel(" ");
    JLabel lambdaDerivingLabel = new JLabel(" ");
    AbstractAction doStepAction = new AbstractAction("Do Step"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            LambdaPane.this.controller.doStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            LambdaPane.this.controller.doAll();
        }
    };
    AbstractAction proceedAction = new AbstractAction("Proceed"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            GrammarTransformAction.hypothesizeUnit(LambdaPane.this.environment, LambdaPane.this.getGrammar());
        }
    };
    AbstractAction exportAction = new AbstractAction("Export"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameFactory.createFrame(LambdaPane.this.editingGrammarView.getGrammar(LambdaPane.this.grammar.getClass()));
        }
    };
    boolean editingActive = false;
    private int editingRow = -1;
    private boolean[] editingColumn = new boolean[2];
    GrammarTableModel editingGrammarModel = new GrammarTableModel(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int r, int c) {
            if (LambdaPane.this.controller.step != 2) {
                return false;
            }
            if (c == 1) {
                return false;
            }
            if (LambdaPane.this.editingRow == -1) {
                if (r == this.getRowCount() - 1) {
                    LambdaPane.this.editingRow = r;
                    ((LambdaPane)LambdaPane.this).editingColumn[1] = false;
                    ((LambdaPane)LambdaPane.this).editingColumn[0] = false;
                    return true;
                }
                return false;
            }
            return LambdaPane.this.editingRow == r;
        }
    };
    GrammarTable editingGrammarView = new GrammarTable(this.editingGrammarModel);
    AbstractAction deleteAction = new AbstractAction("Delete"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            LambdaPane.this.deleteActivated();
        }
    };
    AbstractAction completeSelectedAction = new AbstractAction("Complete Selected"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            LambdaPane.this.cancelEditing();
            int i = 0;
            while (i < LambdaPane.this.grammarTable.getRowCount() - 1) {
                if (LambdaPane.this.grammarTable.isRowSelected(i)) {
                    LambdaPane.this.controller.expandRowProduction(i);
                }
                ++i;
            }
        }
    };

    public LambdaPane(GrammarEnvironment environment, Grammar grammar) {
        this.environment = environment;
        this.grammar = grammar;
        this.controller = new LambdaController(this, grammar);
        this.initView();
    }

    private void initView() {
        super.setLayout(new BorderLayout());
        this.initGrammarTable();
        JPanel rightPanel = this.initRightPanel();
        JSplitPane mainSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, new JScrollPane(this.grammarTable), rightPanel);
        this.add((Component)mainSplit, "Center");
        this.add((Component)new TableTextSizeSlider(this.grammarTable, 0), "North");
    }

    private JPanel initRightPanel() {
        JPanel right = new JPanel(new BorderLayout());
        this.mainLabel.setAlignmentX(0.0f);
        this.detailLabel.setAlignmentX(0.0f);
        this.lambdaDerivingLabel.setAlignmentX(0.0f);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.mainLabel);
        panel.add(this.detailLabel);
        panel.add(this.lambdaDerivingLabel);
        this.initEditingGrammarTable();
        JToolBar editingBar = new JToolBar();
        editingBar.setAlignmentX(0.0f);
        editingBar.setFloatable(false);
        editingBar.add(this.deleteAction);
        editingBar.add(this.completeSelectedAction);
        panel.add(editingBar);
        panel.add(new JScrollPane(this.editingGrammarView));
        JToolBar toolbar = new JToolBar();
        toolbar.setAlignmentX(0.0f);
        toolbar.add(this.doStepAction);
        toolbar.add(this.doAllAction);
        toolbar.addSeparator();
        toolbar.add(this.proceedAction);
        toolbar.add(this.exportAction);
        right.add((Component)toolbar, "North");
        right.add((Component)panel, "Center");
        return right;
    }

    private GrammarTable initGrammarTable() {
        this.grammarTable = new GrammarTable(new GrammarTableModel(this.grammar){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        this.grammarTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Point at;
                GrammarTable gt = (GrammarTable)event.getSource();
                int row = gt.rowAtPoint(at = event.getPoint());
                if (row == -1) {
                    return;
                }
                if (row == gt.getGrammarModel().getRowCount() - 1) {
                    return;
                }
                Production p = gt.getGrammarModel().getProduction(row);
                LambdaPane.this.controller.productionClicked(p, event);
            }
        });
        this.grammarTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LambdaPane.this.updateCompleteSelectedEnabledness();
            }
        });
        return this.grammarTable;
    }

    void updateDeleteEnabledness() {
        if (this.controller.step != 2) {
            this.deleteAction.setEnabled(false);
            return;
        }
        int min = this.editingGrammarView.getSelectionModel().getMinSelectionIndex();
        if (min == -1 || min >= this.editingGrammarModel.getRowCount() - 1) {
            this.deleteAction.setEnabled(false);
            return;
        }
        this.deleteAction.setEnabled(true);
    }

    void updateCompleteSelectedEnabledness() {
        if (this.controller.step != 2) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        int min = this.grammarTable.getSelectionModel().getMinSelectionIndex();
        if (min == -1 || min >= this.grammarTable.getGrammarModel().getRowCount() - 1) {
            this.completeSelectedAction.setEnabled(false);
            return;
        }
        this.completeSelectedAction.setEnabled(true);
    }

    private void initEditingGrammarTable() {
        this.editingGrammarModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                if (!LambdaPane.this.editingActive) {
                    return;
                }
                int r = event.getFirstRow();
                if (event.getType() != 0) {
                    return;
                }
                ((LambdaPane)LambdaPane.this).editingColumn[event.getColumn() >> 1] = true;
                if (LambdaPane.this.editingColumn[0] && LambdaPane.this.editingColumn[1]) {
                    Production p = LambdaPane.this.editingGrammarModel.getProduction(r);
                    if (p == null) {
                        return;
                    }
                    if (!LambdaPane.this.controller.productionAdded(p, r)) {
                        LambdaPane.this.editingGrammarModel.deleteRow(r);
                    }
                    LambdaPane.this.editingRow = -1;
                }
            }
        });
        this.editingGrammarView.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LambdaPane.this.updateDeleteEnabledness();
            }
        });
        Object o = new Object();
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(8, 0), o);
        this.editingGrammarView.getInputMap().put(KeyStroke.getKeyStroke(127, 0), o);
        this.editingGrammarView.getActionMap().put(o, this.deleteAction);
    }

    void cancelEditing() {
        if (this.editingGrammarView.getCellEditor() != null) {
            this.editingGrammarView.getCellEditor().stopCellEditing();
        }
        if (this.editingRow != -1) {
            this.editingGrammarModel.deleteRow(this.editingRow);
            this.editingRow = -1;
        }
    }

    public Grammar getGrammar() {
        return this.editingGrammarView.getGrammar(this.grammar.getClass());
    }

    private void deleteActivated() {
        if (this.controller.step != 2) {
            return;
        }
        this.cancelEditing();
        int deleted = 0;
        int kept = 0;
        int i = this.editingGrammarModel.getRowCount() - 2;
        while (i >= 0) {
            if (this.editingGrammarView.isRowSelected(i)) {
                Production p = this.editingGrammarModel.getProduction(i);
                if (this.controller.productionDeleted(p, i)) {
                    this.editingGrammarModel.deleteRow(i);
                    ++deleted;
                } else {
                    ++kept;
                }
            }
            --i;
        }
        if (kept != 0) {
            JOptionPane.showMessageDialog(this, String.valueOf(kept) + " production(s) selected should not be removed.\n" + deleted + " production(s) were removed.", "Bad Selection", 0);
        }
        if (deleted != 0) {
            this.controller.updateDisplay();
        }
    }
}

