/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.LambdaPane;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class LambdaController {
    LambdaPane pane;
    Grammar grammar;
    LambdaProductionRemover remover = new LambdaProductionRemover();
    Set<String> lambdaVariables;
    Set<String> derivedLambdaVariables;
    Set<Production> desiredProductions = new HashSet<Production>();
    Set<Production> currentProductions = new HashSet<Production>();
    Set<Production> lambdaProductions = new HashSet<Production>();
    Map<Production, Production[]> productionsToExpansion = new HashMap<Production, Production[]>();
    int step = 0;
    static final int VARAIBLE_SELECT = 1;
    static final int PRODUCTION_MODIFY = 2;
    static final int FINISHED = 3;

    public LambdaController(LambdaPane pane, Grammar grammar) {
        this.pane = pane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step != 3) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Select variables that derive lambda.");
                this.pane.detailLabel.setText("Click productions; the LHS variable will be added.");
                this.lambdaVariables = this.remover.getCompleteLambdaSet(this.grammar);
                this.derivedLambdaVariables = new TreeSet<String>();
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                break;
            }
            case 2: {
                this.pane.updateDeleteEnabledness();
                this.pane.updateCompleteSelectedEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove lambdas.");
                Production[] p = this.grammar.getProductions();
                int i = 0;
                while (i < p.length) {
                    this.pane.editingGrammarModel.addProduction(p[i]);
                    this.currentProductions.add(p[i]);
                    if (p[i].getRHS().length() == 0) {
                        this.lambdaProductions.add(p[i]);
                    } else {
                        Production[] p2 = this.remover.getProductionsToAddForProduction(p[i], this.lambdaVariables);
                        this.desiredProductions.add(p[i]);
                        this.productionsToExpansion.put(p[i], p2);
                        int j = 0;
                        while (j < p2.length) {
                            this.desiredProductions.add(p2[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                this.pane.editingActive = true;
                this.updateDisplay();
                break;
            }
            case 3: {
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.mainLabel.setText("Lambda removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
            }
        }
    }

    public Map<Production, Production[]> getExpansionMap() {
        return this.productionsToExpansion;
    }

    public void expandRowProduction(int row) {
        Production p = this.pane.grammarTable.getGrammarModel().getProduction(row);
        Production[] ps = this.productionsToExpansion.get(p);
        if (ps == null) {
            return;
        }
        this.pane.editingActive = false;
        int i = 0;
        while (i < ps.length) {
            if (!this.currentProductions.contains(ps[i]) && this.desiredProductions.contains(ps[i])) {
                this.pane.editingGrammarModel.addProduction(ps[i]);
                this.currentProductions.add(ps[i]);
            }
            this.productionsToExpansion.remove(p);
            ++i;
        }
        this.pane.editingActive = true;
        this.updateDisplay();
    }

    public void doStep() {
        switch (this.step) {
            case 1: {
                this.derivedLambdaVariables = this.lambdaVariables;
                this.pane.lambdaDerivingLabel.setText("Set that derives lambda: " + this.derivedLambdaVariables);
                this.nextStep();
                break;
            }
            case 2: {
                int i = this.pane.editingGrammarModel.getRowCount() - 2;
                while (i >= 0) {
                    Production p = this.pane.editingGrammarModel.getProduction(i);
                    if (this.lambdaProductions.contains(p)) {
                        this.pane.editingGrammarModel.deleteRow(i);
                        this.lambdaProductions.remove(p);
                    }
                    --i;
                }
                GrammarTableModel m = this.pane.grammarTable.getGrammarModel();
                int i2 = 0;
                while (i2 < m.getRowCount() - 1) {
                    this.expandRowProduction(i2);
                    ++i2;
                }
                this.nextStep();
                break;
            }
        }
    }

    public void doAll() {
        while (this.step != 3) {
            this.doStep();
        }
    }

    public Grammar getGrammar() {
        return this.pane.getGrammar();
    }

    public Set<Production> getLambdaSet() {
        return this.lambdaProductions;
    }

    void updateDisplay() {
        int toRemove = this.lambdaProductions.size();
        int toAdd = this.desiredProductions.size() - this.currentProductions.size() + this.lambdaProductions.size();
        this.pane.detailLabel.setText(String.valueOf(toRemove) + " more remove(s), and " + toAdd + " more addition(s) needed.");
        if (toAdd == 0 && toRemove == 0) {
            this.nextStep();
        }
    }

    void productionClicked(Production production, MouseEvent event) {
        switch (this.step) {
            case 1: {
                String var = production.getLHS();
                if (this.derivedLambdaVariables.contains(var)) {
                    this.pane.detailLabel.setText(String.valueOf(var) + " already selected!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                    return;
                }
                if (this.lambdaVariables.contains(var)) {
                    this.derivedLambdaVariables.add(var);
                    this.pane.detailLabel.setText(String.valueOf(var) + " added!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                    this.pane.lambdaDerivingLabel.setText("Set that derives lambda: " + this.derivedLambdaVariables);
                    if (this.derivedLambdaVariables.size() == this.lambdaVariables.size()) {
                        this.nextStep();
                    }
                    return;
                }
                this.pane.detailLabel.setText(String.valueOf(var) + " does not derive lambda!  " + (this.lambdaVariables.size() - this.derivedLambdaVariables.size()) + " more variable(s) needed.");
                break;
            }
            case 2: {
                break;
            }
        }
    }

    boolean productionAdded(Production production, int row) {
        if (this.currentProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is already in the grammar.", "Production Already Here", 0);
            return false;
        }
        if (!this.desiredProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is not part of the reformed grammar.", "Production Not Desired", 0);
            return false;
        }
        this.currentProductions.add(production);
        this.updateDisplay();
        return true;
    }

    boolean productionDeleted(Production production, int row) {
        if (!this.lambdaProductions.contains(production)) {
            return false;
        }
        this.lambdaProductions.remove(production);
        this.currentProductions.remove(production);
        return true;
    }
}

