/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.ParseNode;
import grammar.parse.UserParser;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.SelectableUnrestrictedTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class UserControlParsePane
extends BruteParsePane {
    private static final long serialVersionUID = 1L;
    private UserParser myParser;
    private int mySelectedProductionIndex = -1;
    private Action myPreviousAction;
    private int myStepCount = 0;
    private int myPreviousCount = 0;
    private DefaultListModel<String> myJListModel;
    private JList<String> myStringJList;
    private String myTarget;

    public UserControlParsePane(GrammarEnvironment environment, Grammar grammar) {
        super(environment, grammar, null);
        this.intializeGrammarTableSetting();
    }

    @Override
    protected void initView() {
        this.initTreePanel();
        JTable pt = this.initParseTable();
        JScrollPane parseTable = pt == null ? null : new JScrollPane(pt);
        GrammarTable g = this.initGrammarTable(this.grammar);
        JScrollPane grammarTable = new JScrollPane(g);
        this.myJListModel = new DefaultListModel();
        this.myStringJList = new JList<String>(this.myJListModel);
        this.myStringJList.setLayoutOrientation(2);
        this.addMultipleSelectionToJList();
        this.myStringJList.setVisibleRowCount(1);
        JScrollPane scroll = new JScrollPane(this.myStringJList);
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        JTable table = this.initDerivationTable();
        JPanel derivationPanel = new JPanel();
        derivationPanel.setLayout(new BorderLayout());
        derivationPanel.add((Component)table, "Center");
        derivationPanel.add((Component)new TableTextSizeSlider(table, 0), "North");
        this.derivationPane = new JScrollPane(derivationPanel);
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, grammarTable, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, parseTable, this.initInputPanel());
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, false, 0.52, this.bottomSplit, scroll);
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
        this.add((Component)new TableTextSizeSlider(g, 0), "North");
    }

    private void addMultipleSelectionToJList() {
        this.myStringJList.setSelectionModel(new DefaultListSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (this.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
    }

    private void intializeGrammarTableSetting() {
        this.grammarTable.setSelectionMode(0);
        this.grammarTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                UserControlParsePane.this.mySelectedProductionIndex = UserControlParsePane.this.grammarTable.getSelectedRow();
                if (UserControlParsePane.this.mySelectedProductionIndex > -1 && UserControlParsePane.this.mySelectedProductionIndex < UserControlParsePane.this.grammarTable.getRowCount() - 1 && UserControlParsePane.this.myTarget != null) {
                    UserControlParsePane.this.stepAction.setEnabled(true);
                } else {
                    UserControlParsePane.this.stepAction.setEnabled(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.grammarTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                UserControlParsePane.this.mySelectedProductionIndex = UserControlParsePane.this.grammarTable.getSelectedRow();
                if (UserControlParsePane.this.mySelectedProductionIndex > -1 && UserControlParsePane.this.mySelectedProductionIndex < UserControlParsePane.this.grammarTable.getRowCount() - 1 && UserControlParsePane.this.myTarget != null) {
                    UserControlParsePane.this.stepAction.setEnabled(true);
                } else {
                    UserControlParsePane.this.stepAction.setEnabled(false);
                }
            }
        });
    }

    @Override
    public void input(String string) {
        this.myTarget = string;
        this.startParseInput(string, null);
    }

    protected void previous() {
        ParseNode previous = this.myParser.getPreviousAnswer();
        this.addAnswerToList(previous.getDerivation());
        this.treePanel.setAnswer(previous);
        this.treePanel.repaint();
        if (previous.getProductions().length > 0) {
            this.statusDisplay.setText("Derived current Strings using " + previous.getProductions()[0] + " production");
        } else {
            this.statusDisplay.setText("");
        }
        ++this.myPreviousCount;
        if (this.myStepCount == this.myPreviousCount) {
            this.myPreviousAction.setEnabled(false);
            this.myStepCount = 0;
            this.myPreviousCount = 0;
        }
        this.stepAction.setEnabled(true);
        this.progress.setText(null);
    }

    @Override
    protected JToolBar initInputToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.startAction);
        this.myPreviousAction = new AbstractAction("Previous"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserControlParsePane.this.previous();
            }
        };
        this.myPreviousAction.setEnabled(false);
        toolbar.add(this.myPreviousAction);
        this.stepAction.setEnabled(false);
        toolbar.add(this.stepAction);
        toolbar.addSeparator();
        final JComboBox<String> box = new JComboBox<String>(this.getViewChoices());
        box.setSelectedIndex(0);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserControlParsePane.this.changeView((String)box.getSelectedItem());
            }
        };
        box.addActionListener(listener);
        toolbar.add(box);
        return toolbar;
    }

    @Override
    public boolean step() {
        int count = this.myParser.checkValidAndParse(this.grammarTable.getSelectedRow());
        String lhs = this.myParser.getLHSForProduction(this.grammarTable.getSelectedRow());
        int length = lhs.length();
        int index = -1;
        if (count > 0) {
            if (count > 1) {
                if (this.myStringJList.getSelectedIndex() < 0) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                String temp = "";
                int[] tempIndices = this.myStringJList.getSelectedIndices();
                int tempCount = 0;
                int i = 0;
                while (i < tempIndices.length) {
                    if (this.myJListModel.getElementAt(tempIndices[i]).equals(lhs)) {
                        ++tempCount;
                    }
                    ++i;
                }
                if (tempCount == tempIndices.length) {
                    this.myParser.subsitute(tempIndices);
                    this.paintTree();
                    if (this.myParser.isFinished()) {
                        this.progress.setText("String Accepted!");
                        this.stepAction.setEnabled(false);
                    }
                    this.myPreviousAction.setEnabled(true);
                    ++this.myStepCount;
                    return true;
                }
                if (tempIndices.length != length) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                i = 0;
                while (i < length) {
                    temp = String.valueOf(temp) + this.myJListModel.getElementAt(this.myStringJList.getSelectedIndex() + i);
                    ++i;
                }
                if (!lhs.equals(temp)) {
                    JOptionPane.showMessageDialog(this, "Multiple Variable Detected, Please click the Variable you want to continue", "Select Variable", 0);
                    return false;
                }
                index = this.myStringJList.getSelectedIndex();
            }
            this.myParser.parse(index);
            this.paintTree();
            if (this.myParser.isFinished()) {
                this.progress.setText("String Accepted!");
                this.stepAction.setEnabled(false);
            }
            this.myPreviousAction.setEnabled(true);
            ++this.myStepCount;
            return true;
        }
        JOptionPane.showMessageDialog(this, "Previous Derivation does not support this Production", "Bad Input", 0);
        this.stepAction.setEnabled(false);
        return false;
    }

    private void paintTree() {
        this.addAnswerToList(this.myParser.getAnswer().getDerivation());
        ParseNode answer = this.myParser.getAnswer();
        this.treePanel.setAnswer(answer);
        this.treePanel.repaint();
        if (answer.getProductions().length > 0) {
            this.statusDisplay.setText("Derived current Strings using " + answer.getProductions()[0] + " production");
        } else {
            this.statusDisplay.setText("");
        }
        if (this.myParser.isStringTerminal(answer.getDerivation())) {
            this.progress.setText("No Additional Production is Possible");
            this.stepAction.setEnabled(false);
        }
    }

    private void addAnswerToList(String answer) {
        this.myJListModel.removeAllElements();
        int i = 0;
        while (i < answer.length()) {
            this.myJListModel.addElement(answer.substring(i, i + 1));
            ++i;
        }
    }

    @Override
    protected JComponent initTreePanel() {
        this.treePanel = new SelectableUnrestrictedTreePanel(this);
        return this.treePanel;
    }

    public void startParseInput(String string, UserParser newParser) {
        if (string.equals("")) {
            return;
        }
        if (newParser == null) {
            try {
                this.myParser = UserParser.get(this.grammar, string);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.myParser = newParser;
        }
        this.progress.setText("");
        this.myPreviousAction.setEnabled(false);
        this.stepAction.setEnabled(false);
        this.grammarTable.clearSelection();
        this.myStepCount = 0;
        this.myPreviousCount = 0;
        this.myParser.start();
        this.paintTree();
    }
}

