/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import gui.environment.Universe;
import gui.grammar.parse.LRParsePane;
import gui.tree.Trees;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class LRParseController {
    private IntStack STACK;
    private Production[] productions;
    private int P;
    private String STRING;
    private int NODECOUNT;
    private int reduceStep = 0;
    private int reduceState;
    private LRParsePane pane;
    private DefaultTreeModel tree;
    private TreeNode[] nodes;

    public LRParseController(LRParsePane pane) {
        this.pane = pane;
        this.productions = pane.grammar.getProductions();
    }

    public void initialize(String string) {
        DefaultTreeModel oldTree = this.tree;
        this.tree = this.parseTree(string, this.pane.grammar, this.pane.table);
        if (this.tree == null) {
            this.tree = oldTree;
            this.pane.statusDisplay.setText("Preliminary parse failed.");
            return;
        }
        this.dehighlight();
        this.pane.treeDrawer.setModel(this.tree);
        this.pane.treeDrawer.hideAll();
        this.pane.treePanel.repaint();
        this.pane.stepAction.setEnabled(true);
        this.pane.derivationModel.setRowCount(0);
        this.pane.derivationModel.addRow(new String[]{"", string});
        this.reduceStep = 0;
        this.STRING = String.valueOf(string) + "$";
        this.P = 0;
        this.STACK = new IntStack();
        this.NODECOUNT = 0;
        this.STACK.push(0);
        this.updateStatus();
        this.pane.statusDisplay.setText("Press step to begin.");
    }

    private void updateStatus() {
        this.pane.stackDisplay.setText(this.stackString());
        this.pane.inputDisplay.setText(this.STRING.substring(this.P));
    }

    private String stackString() {
        Object[] o = this.STACK.toArray();
        StringBuffer sb = new StringBuffer();
        int i = o.length - 1;
        while (i >= 0) {
            sb.append(o[i]);
            --i;
        }
        return sb.toString();
    }

    private String derivationString() {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < this.STACK.size()) {
            sb.append(this.STACK.get(i));
            i += 2;
        }
        sb.append(this.STRING.substring(this.P, this.STRING.length() - 1));
        return sb.toString();
    }

    public void step() {
        this.dehighlight();
        int state = this.STACK.peekInt();
        if (this.reduceStep == 1) {
            state = this.reduceState;
        }
        String read = "" + this.STRING.charAt(this.P);
        String entry = "";
        try {
            entry = this.pane.table.getValueAt(state, read);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (entry.length() == 0 || Character.isDigit(entry.charAt(0))) {
            this.pane.stepAction.setEnabled(false);
            this.pane.statusDisplay.setText("String rejected");
        } else if (entry.charAt(0) == 's') {
            int newState = Integer.parseInt(entry.substring(1));
            this.STACK.push(read);
            this.STACK.push(newState);
            ++this.P;
            this.pane.treeDrawer.show(this.nodes[this.NODECOUNT++]);
            this.pane.treePanel.repaint();
            this.pane.statusDisplay.setText("Shifting " + read);
            this.highlight(state, read);
        } else if (entry.charAt(0) == 'r') {
            int prodNumber = Integer.parseInt(entry.substring(1));
            Production red = this.productions[prodNumber];
            String displayString = "Reducing by " + red + ", ";
            this.highlight(prodNumber);
            if (this.reduceStep == 0) {
                this.highlight(state, read);
                TreeNode[] children = Trees.children(this.nodes[this.NODECOUNT]);
                if (children.length == 1 && !this.pane.treeDrawer.isVisible(children[0])) {
                    this.pane.statusDisplay.setText(displayString);
                    this.pane.treeDrawer.show(children[0]);
                    this.pane.treePanel.repaint();
                }
                String popped = "";
                int i = 0;
                while (i < red.getRHS().length()) {
                    this.STACK.pop();
                    popped = this.STACK.pop() + popped;
                    ++i;
                }
                if (popped.length() == 0) {
                    popped = Universe.curProfile.getEmptyString();
                }
                displayString = String.valueOf(displayString) + popped + " popped off stack";
                this.reduceStep = 1;
                this.reduceState = state;
            } else if (this.reduceStep == 1) {
                state = this.STACK.peekInt();
                this.highlight(state, red.getLHS());
                displayString = String.valueOf(displayString) + red.getLHS() + " pushed on stack";
                this.STACK.push(red.getLHS());
                this.STACK.push(Integer.parseInt(this.pane.table.getValueAt(state, red.getLHS())));
                this.pane.treeDrawer.show(this.nodes[this.NODECOUNT++]);
                this.pane.derivationModel.addRow(new String[]{red.toString(), this.derivationString()});
                this.reduceStep = 0;
            }
            this.pane.statusDisplay.setText(displayString);
            this.pane.treePanel.repaint();
        } else if (entry.charAt(0) == 'a') {
            this.STACK.pop();
            this.pane.stepAction.setEnabled(false);
            this.pane.statusDisplay.setText("String accepted");
            this.highlight(state, read);
        }
        this.updateStatus();
    }

    private void highlight(int id, String symbol) {
        int column = this.pane.table.columnForSymbol(symbol);
        this.pane.tablePanel.highlight(id, column);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void highlight(int row) {
        this.pane.grammarTable.highlight(row, 0);
        this.pane.grammarTable.highlight(row, 2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void dehighlight() {
        this.pane.tablePanel.dehighlight();
        this.pane.grammarTable.dehighlight();
    }

    private DefaultTreeModel parseTree(String string, Grammar grammar, LRParseTable table) {
        string = String.valueOf(string) + "$";
        int p = 0;
        int numberOfIterations = 0;
        int numberTillNextWarning = 500;
        IntStack stack = new IntStack();
        stack.push(0);
        Production[] productions = grammar.getProductions();
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
        while (true) {
            int state = stack.peekInt();
            String read = "" + string.charAt(p);
            String entry = "";
            try {
                entry = table.getValueAt(state, read);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (entry.length() == 0 || Character.isDigit(entry.charAt(0))) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode();
                Object[] elements = stack.toArray();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof MutableTreeNode) {
                        node.add((MutableTreeNode)elements[i]);
                    }
                    ++i;
                }
                this.nodes = nodeList.toArray(new TreeNode[0]);
                return new DefaultTreeModel(node);
            }
            if (entry.charAt(0) == 's') {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(read, false);
                stack.push(node);
                nodeList.add(node);
                stack.push(Integer.parseInt(entry.substring(1)));
                ++p;
            } else if (entry.charAt(0) == 'r') {
                int prodNumber = Integer.parseInt(entry.substring(1));
                Production red = productions[prodNumber];
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(red.getLHS());
                int i = 0;
                while (i < red.getRHS().length()) {
                    stack.pop();
                    MutableTreeNode c = (MutableTreeNode)stack.pop();
                    node.insert(c, 0);
                    ++i;
                }
                if (red.getRHS().length() == 0) {
                    DefaultMutableTreeNode lambda = new DefaultMutableTreeNode(Universe.curProfile.getEmptyString());
                    node.insert(lambda, 0);
                }
                state = stack.peekInt();
                stack.push(node);
                stack.push(Integer.parseInt(table.getValueAt(state, red.getLHS())));
                nodeList.add(node);
            } else if (entry.charAt(0) == 'a') {
                stack.pop();
                this.nodes = nodeList.toArray(new TreeNode[0]);
                return new DefaultTreeModel((TreeNode)stack.pop());
            }
            if (++numberOfIterations < numberTillNextWarning) continue;
            int result = JOptionPane.showConfirmDialog(this.pane, String.valueOf(numberOfIterations) + " nodes have been generated.  Should we continue?");
            if (result == 1) {
                return null;
            }
            numberTillNextWarning *= 2;
        }
    }

    private static class IntStack
    extends Stack<Object> {
        private static final long serialVersionUID = 1L;

        private IntStack() {
        }

        @Override
        int push(int item) {
            this.push(new Integer(item));
            return item;
        }

        int popInt() {
            return (Integer)this.pop();
        }

        int peekInt() {
            return (Integer)this.peek();
        }
    }
}

