/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.parse.LLParseTable;
import gui.HighlightTable;
import gui.LeftTable;
import gui.environment.Universe;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LLParseTablePane
extends LeftTable {
    private LLParseTable table;
    private static final HighlightTable.TableHighlighterRendererGenerator THRG = new HighlightTable.TableHighlighterRendererGenerator(){
        private DefaultTableCellRenderer renderer = null;

        @Override
        public TableCellRenderer getRenderer(int row, int column) {
            if (this.renderer == null) {
                this.renderer = new LambdaCellRenderer();
                this.renderer.setBackground(new Color(255, 150, 150));
            }
            return this.renderer;
        }
    };
    private static final TableCellRenderer RENDERER = new LambdaCellRenderer();

    public LLParseTablePane(LLParseTable table) {
        super(table);
        this.table = table;
        this.setCellSelectionEnabled(true);
        int i = 1;
        while (i < this.getColumnCount()) {
            this.getColumnModel().getColumn(i).setCellRenderer(RENDERER);
            ++i;
        }
    }

    public LLParseTable getParseTable() {
        return this.table;
    }

    @Override
    public void highlight(int row, int column) {
        this.highlight(row, column, THRG);
    }

    private static class LambdaCellRenderer
    extends DefaultTableCellRenderer {
        private LambdaCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel l = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus && table.isCellEditable(row, column)) {
                return l;
            }
            l.setText(((String)value).replace('!', Universe.curProfile.getEmptyString().charAt(0)));
            return l;
        }
    }
}

