/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.LLParseTable;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.LLParseDerivationController;
import gui.grammar.parse.LLParseTablePane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class LLParseTableDerivationPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LLParseDerivationController controller;
    private LLParseTablePane parseTable;
    private boolean editable;

    public LLParseTableDerivationPane(GrammarEnvironment environment) {
        super(new BorderLayout());
        Grammar g = environment.getGrammar();
        JPanel right = new JPanel(new BorderLayout());
        JLabel description = new JLabel();
        right.add((Component)description, "North");
        FirstFollowTable fftable = new FirstFollowTable(g);
        fftable.getColumnModel().getColumn(0).setPreferredWidth(30);
        fftable.getFFModel().setCanEditFirst(true);
        fftable.getFFModel().setCanEditFollow(true);
        LLParseTable parseTableModel = new LLParseTable(g){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int r, int c) {
                return ((LLParseTableDerivationPane)LLParseTableDerivationPane.this).controller.step != 3 && super.isCellEditable(r, c);
            }
        };
        this.parseTable = new LLParseTablePane(parseTableModel);
        this.parseTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        JSplitPane rightSplit = SplitPaneFactory.createSplit(environment, false, 0.5, new JScrollPane(fftable), new JScrollPane(this.parseTable));
        right.add((Component)rightSplit, "Center");
        right.add((Component)new TableTextSizeSlider(fftable, 0), "North");
        right.add((Component)new TableTextSizeSlider(this.parseTable, 0), "South");
        this.controller = new LLParseDerivationController(g, environment, fftable, this.parseTable, description);
        GrammarTable table = new GrammarTable(new GrammarTableModel(g){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        });
        JPanel grammarHolder = new JPanel();
        grammarHolder.setLayout(new BorderLayout());
        grammarHolder.add((Component)new TableTextSizeSlider(table, 0), "North");
        grammarHolder.add((Component)table, "Center");
        JSplitPane pane = SplitPaneFactory.createSplit(environment, true, 0.3, grammarHolder, right);
        this.add((Component)pane, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.controller.doSelectedAction);
        toolbar.add(this.controller.doStepAction);
        toolbar.add(this.controller.doAllAction);
        toolbar.addSeparator();
        toolbar.add(this.controller.nextAction);
        toolbar.addSeparator();
        toolbar.add(this.controller.parseAction);
        this.add((Component)toolbar, "North");
    }

    void makeParseUneditable() {
        this.editable = false;
        try {
            this.parseTable.getCellEditor().stopCellEditing();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

