/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.LLParseTable;
import gui.environment.Universe;
import gui.grammar.parse.LLParsePane;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class LLParseController {
    String ENTRY;
    int ENTRYP;
    private Production[] productions;
    private int P;
    private String STRING;
    private int NODECOUNT;
    private Stack<TreeNode> STACK;
    private TreeNode[] NODES;
    private String derivationString;
    private LLParsePane pane;
    private DefaultTreeModel tree;
    private TreeNode[] nodes;
    private int stepMode = 1;
    private static final int INITIALIZE = 1;
    private static final int NORMAL = 2;
    private static final int REPLACING = 3;
    private static final int ERROR = 4;
    private static final int SUCCESS = 5;

    public LLParseController(LLParsePane pane) {
        this.pane = pane;
        this.productions = pane.grammar.getProductions();
    }

    public void initialize(String string) {
        this.dehighlight();
        ArrayList<MutableTreeNode> nodes = new ArrayList<MutableTreeNode>();
        this.tree = this.parseTree(string, this.pane.grammar, this.pane.table, nodes);
        this.pane.treeDrawer.setModel(this.tree);
        this.pane.treeDrawer.hideAll();
        this.pane.treePanel.repaint();
        this.pane.stepAction.setEnabled(true);
        this.pane.derivationModel.setRowCount(0);
        this.NODES = nodes.toArray(new TreeNode[0]);
        this.STRING = String.valueOf(string) + "$";
        this.STACK = new Stack();
        this.P = 0;
        this.NODECOUNT = 0;
        this.stepMode = 1;
        this.updateStatus();
        this.pane.statusDisplay.setText("Press step to begin.");
    }

    private void updateStatus() {
        this.pane.stackDisplay.setText(this.stackString());
        this.pane.inputDisplay.setText(this.STRING.substring(this.P));
    }

    private String stackString() {
        Object[] o = this.STACK.toArray();
        StringBuffer sb = new StringBuffer();
        int i = o.length - 1;
        while (i >= 0) {
            sb.append(o[i]);
            --i;
        }
        return sb.toString();
    }

    private String derivationString() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public void step() {
        String read = this.STRING.substring(this.P, this.P + 1);
        switch (this.stepMode) {
            case 1: {
                this.STACK.push(this.NODES[0]);
                this.pane.treeDrawer.show(this.NODES[0]);
                this.pane.treePanel.repaint();
                ++this.NODECOUNT;
                this.stepMode = 2;
                this.updateStatus();
                this.pane.statusDisplay.setText("Initialization complete.");
                this.derivationString = this.pane.grammar.getStartVariable();
                this.pane.derivationModel.addRow(new String[]{"", this.derivationString});
                break;
            }
            case 2: {
                this.dehighlight();
                if (this.STACK.empty()) {
                    this.stepMode = 5;
                    this.step();
                    return;
                }
                String top = this.STACK.peek().toString();
                if (this.pane.grammar.isTerminal(top)) {
                    if (top.equals(read)) {
                        TreeNode node = this.STACK.pop();
                        this.pane.nodeDrawer.clearSelected();
                        this.pane.nodeDrawer.setSelected(node, true);
                        this.pane.treePanel.repaint();
                        ++this.P;
                        this.pane.statusDisplay.setText("Matched " + read + ".");
                    } else {
                        this.stepMode = 4;
                        this.pane.statusDisplay.setText("Stack and input don't match.");
                    }
                    this.updateStatus();
                    return;
                }
                if (this.pane.grammar.isVariable(top)) {
                    TreeNode node = this.STACK.pop();
                    this.pane.nodeDrawer.clearSelected();
                    this.pane.nodeDrawer.setSelected(node, true);
                    this.pane.treePanel.repaint();
                    this.ENTRY = this.get(top, read);
                    if (this.ENTRY == null) {
                        this.stepMode = 4;
                        this.pane.statusDisplay.setText("No rule for " + top + " with " + read + " as lookahead.");
                        this.updateStatus();
                        return;
                    }
                    this.highlight(top, read);
                    String rule = new Production(top, this.ENTRY).toString();
                    int first = this.derivationString.indexOf(top.charAt(0));
                    this.derivationString = String.valueOf(this.derivationString.substring(0, first)) + this.ENTRY + this.derivationString.substring(first + 1);
                    this.pane.derivationModel.addRow(new String[]{rule, this.derivationString});
                    if (this.ENTRY.length() == 0) {
                        this.ENTRY = Universe.curProfile.getEmptyString();
                    }
                    this.ENTRYP = this.ENTRY.length() - 1;
                    this.pane.statusDisplay.setText("Replacing " + top + " with " + this.ENTRY + ".");
                    this.stepMode = 3;
                }
                this.updateStatus();
                return;
            }
            case 3: {
                if (this.ENTRYP < 0) {
                    this.stepMode = 2;
                    this.step();
                    return;
                }
                TreeNode node = this.NODES[this.NODECOUNT++];
                this.pane.treeDrawer.show(node);
                this.pane.treePanel.repaint();
                if (!node.toString().equals(Universe.curProfile.getEmptyString())) {
                    this.STACK.push(node);
                }
                --this.ENTRYP;
                this.updateStatus();
                return;
            }
            case 4: {
                this.dehighlight();
                this.pane.statusDisplay.setText("String rejected.");
                this.pane.stepAction.setEnabled(false);
                return;
            }
            case 5: {
                this.dehighlight();
                if (!read.equals("$")) {
                    this.pane.statusDisplay.setText("The stack is empty, but the input is not.");
                    this.stepMode = 4;
                } else {
                    this.pane.stepAction.setEnabled(false);
                    this.pane.statusDisplay.setText("String successfully parsed!");
                }
                return;
            }
        }
    }

    private void highlight(String variable, String terminal) {
        int row = this.pane.table.getRow(variable);
        int column = this.pane.table.getColumn(terminal);
        this.pane.tablePanel.highlight(row, column);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void highlight(int row) {
        this.pane.grammarTable.highlight(row, 0);
        this.pane.grammarTable.highlight(row, 2);
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private void dehighlight() {
        this.pane.tablePanel.dehighlight();
        this.pane.grammarTable.dehighlight();
        this.pane.tablePanel.repaint();
        this.pane.grammarTable.repaint();
    }

    private String get(String variable, String lookahead) {
        try {
            return this.pane.table.get(variable, lookahead).first();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private DefaultTreeModel parseTree(String string, Grammar grammar, LLParseTable table, List<MutableTreeNode> nodes) {
        int p = 0;
        string = String.valueOf(string) + "$";
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(grammar.getStartVariable());
        stack.push(root);
        nodes.add(root);
        DefaultTreeModel tree = new DefaultTreeModel(root);
        String read = string.substring(p, p + 1);
        ++p;
        while (!stack.empty()) {
            String top = ((MutableTreeNode)stack.peek()).toString();
            if (this.pane.grammar.isTerminal(top)) {
                if (top.equals(read)) {
                    stack.pop();
                    read = string.substring(p, p + 1);
                    ++p;
                    continue;
                }
                return tree;
            }
            if (!this.pane.grammar.isVariable(top)) continue;
            String entry = this.get(top, read);
            if (entry == null) {
                return tree;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)stack.pop();
            if (entry.length() == 0) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(Universe.curProfile.getEmptyString());
                node.insert(child, 0);
                nodes.add(child);
                continue;
            }
            int i = entry.length() - 1;
            while (i >= 0) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(entry.substring(i, i + 1));
                node.insert(child, 0);
                stack.push(child);
                nodes.add(child);
                --i;
            }
        }
        return tree;
    }
}

