/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.CYKParser;
import grammar.parse.CYKTracer;
import grammar.parse.ParseNode;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.SelectableUnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class CYKParsePane
extends BruteParsePane {
    private static final long serialVersionUID = 1L;
    private CYKParser myParser;
    private Action myStepAction;
    private String myTarget;
    private Grammar myCNFGrammar;
    private boolean myTraceAvailable;
    private ParseNode myCurrentAnswerNode;
    private Production[] myAnswers;
    private LinkedList<ParseNode> myQueue;
    private int myIndex;

    public CYKParsePane(GrammarEnvironment environment, Grammar original, Grammar cnf) {
        super(environment, original, null);
        this.myCNFGrammar = cnf;
        this.myParser = new CYKParser(this.myCNFGrammar);
    }

    public CYKParsePane(GrammarEnvironment environment, Grammar original, Grammar cnf, InputTableModel model) {
        super(environment, original, model);
        this.myCNFGrammar = cnf;
        this.myParser = new CYKParser(this.myCNFGrammar);
        this.myModel = model;
    }

    @Override
    protected void initView() {
        this.initTreePanel();
        JTable pt = this.initParseTable();
        JScrollPane parseTable = pt == null ? null : new JScrollPane(pt);
        GrammarTable g = this.initGrammarTable(this.grammar);
        JScrollPane grammarTable = new JScrollPane(g);
        this.treeDerivationPane.add((Component)this.initTreePanel(), "0");
        JTable table = this.initDerivationTable();
        JPanel derivationPanel = new JPanel();
        derivationPanel.setLayout(new BorderLayout());
        derivationPanel.add((Component)table, "Center");
        derivationPanel.add((Component)new TableTextSizeSlider(table, 0), "North");
        this.derivationPane = new JScrollPane(derivationPanel);
        this.treeDerivationPane.add((Component)this.derivationPane, "1");
        this.bottomSplit = SplitPaneFactory.createSplit(this.environment, true, 0.3, grammarTable, this.treeDerivationPane);
        this.topSplit = SplitPaneFactory.createSplit(this.environment, true, 0.4, parseTable, this.initInputPanel());
        this.mainSplit = SplitPaneFactory.createSplit(this.environment, false, 0.3, this.topSplit, this.bottomSplit);
        this.add((Component)this.mainSplit, "Center");
        this.add((Component)this.statusDisplay, "South");
        this.add((Component)new TableTextSizeSlider(g, 0), "North");
    }

    @Override
    protected JComponent initTreePanel() {
        this.treePanel = new SelectableUnrestrictedTreePanel(this);
        return this.treePanel;
    }

    @Override
    public void input(String string) {
        this.statusDisplay.setText("");
        this.myTarget = string;
        this.treePanel.setAnswer(null);
        this.treePanel.repaint();
        this.derivationModel.setRowCount(0);
        this.myStepAction.setEnabled(false);
        if (this.myParser.solve(string)) {
            this.progress.setText("String is Accepted!");
            this.myTraceAvailable = true;
            this.myStepAction.setEnabled(true);
            this.traceBack();
        } else {
            this.progress.setText("String is Rejected!");
        }
    }

    @Override
    public void parseMultiple() {
        String[][] inputs = this.myModel.getInputs();
        this.row = -1;
        while (this.row < inputs.length - 1) {
            ++this.row;
            if (this.myParser.solve(inputs[this.row][0])) {
                this.myModel.setResult(this.row, "Accept", null, this.environment.myTransducerStrings, this.row);
                continue;
            }
            this.myModel.setResult(this.row, "Reject", null, this.environment.myTransducerStrings, this.row);
        }
    }

    public void traceBack() {
        if (!this.myTraceAvailable) {
            return;
        }
        CYKTracer cykTracer = new CYKTracer(this.grammar, this.myParser.getTrace());
        cykTracer.traceBack();
        this.myAnswers = cykTracer.getAnswer();
        if (!this.myAnswers[0].getLHS().equals(this.grammar.getStartVariable())) {
            int i = 1;
            while (i < this.myAnswers.length) {
                if (this.myAnswers[i].getLHS().equals(this.grammar.getStartVariable())) {
                    Production p = this.myAnswers[0];
                    this.myAnswers[0] = this.myAnswers[i];
                    this.myAnswers[i] = p;
                    break;
                }
                ++i;
            }
        }
        this.myCurrentAnswerNode = new ParseNode(this.grammar.getStartVariable(), new Production[0], new int[0]);
        this.myQueue = new LinkedList();
        this.myQueue.add(this.myCurrentAnswerNode);
        this.myIndex = 0;
        this.stepForward();
    }

    private void stepForward() {
        this.treePanel.setAnswer(this.myCurrentAnswerNode);
        this.treePanel.repaint();
        if (this.myCurrentAnswerNode.getDerivation().equals(this.myTarget)) {
            this.myStepAction.setEnabled(false);
            return;
        }
        ParseNode node = this.myQueue.removeFirst();
        String deriv = node.getDerivation();
        int index = deriv.indexOf(this.myAnswers[this.myIndex].getLHS());
        if (index == -1) {
            this.myStepAction.setEnabled(false);
            return;
        }
        deriv = String.valueOf(deriv.substring(0, index)) + this.myAnswers[this.myIndex].getRHS() + deriv.substring(index + 1);
        int[] temp = new int[]{index};
        Production[] temp1 = new Production[]{this.myAnswers[this.myIndex]};
        ParseNode pNode = new ParseNode(deriv, temp1, temp);
        pNode = new ParseNode(pNode);
        node.add(pNode);
        this.myQueue.add(pNode);
        this.myCurrentAnswerNode = pNode;
        ++this.myIndex;
    }

    @Override
    protected JToolBar initInputToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.startAction);
        this.myStepAction = new AbstractAction("Step"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CYKParsePane.this.stepForward();
            }
        };
        this.myStepAction.setEnabled(false);
        toolbar.add(this.myStepAction);
        toolbar.addSeparator();
        final JComboBox<String> box = new JComboBox<String>(this.getViewChoices());
        box.setSelectedIndex(0);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CYKParsePane.this.changeView((String)box.getSelectedItem());
            }
        };
        box.addActionListener(listener);
        toolbar.add(box);
        return toolbar;
    }
}

