/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.turing.TuringMachine;
import automata.turing.TuringToGrammarConverter;
import grammar.ConvertedUnrestrictedGrammar;
import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import gui.environment.FrameFactory;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;

public class TuringConvertController
extends ConvertController {
    private TuringToGrammarConverter converter;
    private TuringMachine myTuringMachine;

    public TuringConvertController(ConvertPane pane, SelectionDrawer drawer, TuringMachine automaton) {
        super(pane, drawer, automaton);
        this.myTuringMachine = automaton;
        this.converter = new TuringToGrammarConverter();
        pane.getTable().getColumnModel().getColumn(0).setMinWidth(150);
        pane.getTable().getColumnModel().getColumn(0).setMaxWidth(250);
        this.fillMap();
    }

    @Override
    protected Production[] getProductions(State state) {
        if (this.myTuringMachine.isInitialState(state)) {
            Transition[] tm = this.myTuringMachine.getTransitions();
            return this.converter.createProductionsForInit(state, tm);
        }
        return new Production[0];
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        return this.converter.createProductionsForTransition(transition, this.myTuringMachine.getFinalStates());
    }

    @Override
    protected ConvertedUnrestrictedGrammar getGrammar() {
        int rows = this.getModel().getRowCount();
        ConvertedUnrestrictedGrammar grammar = new ConvertedUnrestrictedGrammar();
        grammar.setStartVariable("S");
        ArrayList<Production> productions = new ArrayList<Production>();
        int i = 0;
        while (i < rows) {
            Production production = this.getModel().getProduction(i);
            if (production != null) {
                productions.add(production);
            }
            ++i;
        }
        Collections.sort(productions, new ProductionComp());
        i = 0;
        while (i < productions.size()) {
            grammar.addProduction((Production)productions.get(i));
            ++i;
        }
        return grammar;
    }

    @Override
    public Grammar exportGrammar() {
        if (this.objectToProduction.keySet().size() != this.alreadyDone.size()) {
            this.highlightUntransformed();
            JOptionPane.showMessageDialog(this.convertPane, "Conversion unfinished!  Objects to convert are highlighted.", "Conversion Unfinished", 0);
            this.changeSelection();
            return null;
        }
        try {
            ConvertedUnrestrictedGrammar g = this.getGrammar();
            ArrayList<Production> prods = new ArrayList<Production>();
            Production[] temp = g.getProductions();
            int i = 0;
            while (i < temp.length) {
                prods.add(temp[i]);
                ++i;
            }
            Collections.sort(prods, new Comparator<Production>(){

                @Override
                public int compare(Production o1, Production o2) {
                    if (o1.getLHS().equals("S")) {
                        return -1;
                    }
                    return o1.getRHS().length() - o2.getRHS().length();
                }
            });
            ConvertedUnrestrictedGrammar gg = new ConvertedUnrestrictedGrammar();
            int i2 = 0;
            while (i2 < temp.length) {
                temp[i2] = (Production)prods.get(i2);
                ++i2;
            }
            gg.setStartVariable("S");
            gg.addProductions(temp);
            FrameFactory.createFrame((Serializable)gg, 0);
            return gg;
        }
        catch (GrammarCreationException e) {
            JOptionPane.showMessageDialog(this.convertPane, e.getMessage(), "Error", 0);
            return null;
        }
    }

    private Grammar trim(Production[] prods) {
        char ch = 'A';
        int i = 0;
        while (i < prods.length) {
            String lhs = prods[i].getLHS();
            if (ch == 'S' || ch == 'T') {
                ch = (char)(ch + 1);
            }
            int aa = lhs.indexOf("V(");
            while (aa > -1) {
                int bb = lhs.indexOf(")");
                String var = "";
                if (aa + bb + 1 > lhs.length()) {
                    var = lhs.substring(aa, aa + bb);
                    lhs = String.valueOf(lhs.substring(0, aa)) + ch;
                } else {
                    var = lhs.substring(aa, aa + bb + 1);
                    lhs = String.valueOf(lhs.substring(0, aa)) + ch + lhs.substring(aa + bb);
                }
                aa = lhs.indexOf("V(");
                int k = 0;
                while (k < prods.length) {
                    String inner_lhs = prods[k].getLHS();
                    String inner_rhs = prods[k].getRHS();
                    int a = inner_lhs.indexOf(var);
                    if (a > -1) {
                        inner_lhs = String.valueOf(inner_lhs.substring(0, a)) + ch + inner_lhs.substring(a + var.length());
                    }
                    if ((a = inner_rhs.indexOf(var)) > -1) {
                        inner_rhs = String.valueOf(inner_rhs.substring(0, a)) + ch + inner_rhs.substring(a + var.length());
                    }
                    prods[k] = new Production(inner_lhs, inner_rhs);
                    ++k;
                }
                ch = (char)(ch + '\u0001');
            }
            ++i;
        }
        UnrestrictedGrammar g = new UnrestrictedGrammar();
        g.addProductions(prods);
        return g;
    }

    class ProductionComp
    implements Comparator<Production> {
        ProductionComp() {
        }

        @Override
        public int compare(Production p1, Production p2) {
            if ("S".equals(p1.getLHS())) {
                if (p1.getLHS().equals(p2.getLHS())) {
                    return 0;
                }
                return 1;
            }
            if ("S".equals(p2.getLHS())) {
                return -1;
            }
            return p1.getLHS().compareTo(p2.getLHS());
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }
}

