/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar;

import grammar.Grammar;
import grammar.Production;
import gui.GrowableTableModel;
import gui.grammar.ArrowIcon;
import java.util.ArrayList;
import javax.swing.Icon;

public class GrammarTableModel
extends GrowableTableModel {
    private static final long serialVersionUID = 1L;
    private static Icon ARROW = new ArrowIcon(20, 8);

    public GrammarTableModel() {
        super(3);
    }

    public GrammarTableModel(Grammar grammar) {
        this();
        Production[] ps = grammar.getProductions();
        int i = 0;
        while (i < ps.length) {
            this.addProduction(ps[i]);
            ++i;
        }
    }

    public int addProduction(Production production) {
        int row = this.getRowCount() - 1;
        this.setValueAt(production.getLHS(), row, 0);
        this.setValueAt(production.getRHS(), row, 2);
        return row;
    }

    public int addProduction(Production production, int row) {
        Object[] o = this.initializeRow(row);
        o[0] = production.getLHS();
        o[2] = production.getRHS();
        this.insertRow(o, row);
        return row;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    public Production getProduction(int row) {
        String lhs = (String)this.getValueAt(row, 0);
        if (lhs.equals("")) {
            return null;
        }
        return new Production(lhs, (String)this.getValueAt(row, 2));
    }

    public Production[] getProductions() {
        ArrayList<Production> list = new ArrayList<Production>();
        int i = 0;
        while (i < this.getRowCount() - 1) {
            Production production = this.getProduction(i);
            if (production != null) {
                list.add(production);
            }
            ++i;
        }
        return list.toArray(new Production[0]);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 1;
    }

    @Override
    protected Object[] initializeRow(int row) {
        Object[] newRow = new Object[]{"", ARROW, ""};
        return newRow;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column == 1 ? Icon.class : String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 1 && row == this.getRowCount() - 1) {
            return null;
        }
        return super.getValueAt(row, column);
    }
}

