/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.xml.DOMPrettier;
import gui.editor.TMTransitionCreator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profile {
    public static String LAMBDA = "\u03bb";
    public static String EPSILON = "\u03b5";
    public String lambda = "\u03bb";
    public String epsilon = "\u03b5";
    public String lambdaText = "u03BB";
    public String epsilonText = "u03B5";
    private String emptyString = this.lambda;
    public String Color = "Original";
    public int undo_num = 50;
    public String EMPTY_STRING_NAME = "empty_string";
    public static final String STRUCTURE_NAME = "structure";
    public static final String STRUCTURE_TYPE_NAME = "type";
    public static final String TURING_FINAL_NAME = "turing_final";
    public static final String UNDO_AMOUNT_NAME = "undo_amount";
    public static final String ACCEPT_FINAL_STATE = "turing_accept_by_final_state";
    public static final String ACCEPT_HALT = "turing_accept_by_halt";
    public static final String ALLOW_STAY = "turing_allow_stay_on_transition";
    private boolean transTuringFinal = false;
    private boolean turingAcceptByFinalState;
    private boolean turingAcceptByHalting;
    private boolean turingAllowStay;
    private JCheckBoxMenuItem transTuringFinalCheckBox = new JCheckBoxMenuItem("Enable Transitions From Turing Machine Final States");
    private JCheckBoxMenuItem turingAcceptByFinalStateCheckBox;
    private JCheckBoxMenuItem turingAcceptByHaltingCheckBox;
    private JCheckBoxMenuItem turingAllowStayCheckBox;
    public String pathToFile = "";

    public void setNumUndo(int nn) {
        this.undo_num = nn;
    }

    public Profile() {
        this.transTuringFinalCheckBox.setSelected(this.transTuringFinal);
        this.transTuringFinalCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Profile.this.setTransitionsFromTuringFinalStateAllowed(Profile.this.transTuringFinalCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAcceptByFinalState = true;
        this.turingAcceptByFinalStateCheckBox = new JCheckBoxMenuItem("Accept by Final State");
        this.turingAcceptByFinalStateCheckBox.setSelected(this.turingAcceptByFinalState);
        this.turingAcceptByFinalStateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Profile.this.setAcceptByFinalState(Profile.this.turingAcceptByFinalStateCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAcceptByHalting = false;
        this.turingAcceptByHaltingCheckBox = new JCheckBoxMenuItem("Accept by Halting");
        this.turingAcceptByHaltingCheckBox.setSelected(this.turingAcceptByHalting);
        this.turingAcceptByHaltingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Profile.this.setAcceptByHalting(Profile.this.turingAcceptByHaltingCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAllowStay = false;
        this.turingAllowStayCheckBox = new JCheckBoxMenuItem("Allow stay for tape head on transition");
        this.turingAllowStayCheckBox.setSelected(this.turingAllowStay);
        this.turingAllowStayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Profile.this.setAllowStay(Profile.this.turingAllowStayCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
    }

    public void setEmptyString(String empty) {
        this.emptyString = empty;
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setColor(String color) {
        this.Color = color;
    }

    public String getColor() {
        return this.Color;
    }

    public void setTransitionsFromTuringFinalStateAllowed(boolean t) {
        this.transTuringFinal = t;
        this.transTuringFinalCheckBox.setSelected(t);
    }

    public void setAcceptByFinalState(boolean t) {
        this.turingAcceptByFinalState = t;
        this.turingAcceptByFinalStateCheckBox.setSelected(t);
    }

    public void setAcceptByHalting(boolean t) {
        this.turingAcceptByHalting = t;
        this.turingAcceptByHaltingCheckBox.setSelected(t);
    }

    public void setAllowStay(boolean t) {
        this.turingAllowStay = t;
        this.turingAllowStayCheckBox.setSelected(t);
        TMTransitionCreator.setDirs(t);
    }

    public boolean transitionsFromTuringFinalStateAllowed() {
        return this.transTuringFinal;
    }

    public boolean getAcceptByFinalState() {
        return this.turingAcceptByFinalState;
    }

    public boolean getAcceptByHalting() {
        return this.turingAcceptByHalting;
    }

    public JCheckBoxMenuItem getTuringFinalCheckBox() {
        return this.transTuringFinalCheckBox;
    }

    public JCheckBoxMenuItem getAcceptByFinalStateCheckBox() {
        return this.turingAcceptByFinalStateCheckBox;
    }

    public JCheckBoxMenuItem getAcceptByHaltingCheckBox() {
        return this.turingAcceptByHaltingCheckBox;
    }

    public JCheckBoxMenuItem getAllowStayCheckBox() {
        return this.turingAllowStayCheckBox;
    }

    public void savePreferences() {
        String empty = "";
        if (this.emptyString.equals(this.lambda)) {
            empty = this.lambdaText;
        } else if (this.emptyString.equals(this.epsilon)) {
            empty = this.epsilonText;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            File file = new File(this.pathToFile);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            doc.appendChild(doc.createComment("Created with JFLAP 7.1."));
            Element structureElement = Profile.createElement(doc, STRUCTURE_NAME, null, null);
            doc.appendChild(structureElement);
            Element se = doc.getDocumentElement();
            Element element = Profile.createElement(doc, this.EMPTY_STRING_NAME, null, empty);
            se.appendChild(element);
            element = Profile.createElement(doc, TURING_FINAL_NAME, null, "" + this.transTuringFinal);
            se.appendChild(element);
            element = Profile.createElement(doc, UNDO_AMOUNT_NAME, null, "" + this.undo_num);
            se.appendChild(element);
            element = Profile.createElement(doc, ACCEPT_FINAL_STATE, null, "" + this.turingAcceptByFinalState);
            se.appendChild(element);
            element = Profile.createElement(doc, ACCEPT_HALT, null, "" + this.turingAcceptByHalting);
            se.appendChild(element);
            element = Profile.createElement(doc, ALLOW_STAY, null, "" + this.turingAllowStay);
            se.appendChild(element);
            DOMPrettier.makePretty(doc);
            DOMSource s = new DOMSource(doc);
            StreamResult r = new StreamResult(file);
            try {
                Transformer t = TransformerFactory.newInstance().newTransformer();
                try {
                    t.transform(s, r);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
            }
            catch (TransformerConfigurationException e1) {
                e1.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e1) {
                e1.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    protected static Element createElement(Document document, String tagname, Map<?, ?> attributes, String text) {
        Element element = document.createElement(tagname);
        if (text != null) {
            element.appendChild(document.createTextNode(text));
        }
        return element;
    }
}

