/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import automata.Automaton;
import automata.mealy.MealyMachine;
import automata.mealy.MooreMachine;
import grammar.ConvertedUnrestrictedGrammar;
import grammar.Grammar;
import grammar.lsystem.LSystem;
import gui.editor.EditorPane;
import gui.editor.MealyToolBox;
import gui.editor.MooreToolBox;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.GrammarEnvironment;
import gui.environment.LSystemEnvironment;
import gui.environment.PumpingLemmaEnvironment;
import gui.environment.RegularEnvironment;
import gui.environment.tag.CriticalTag;
import gui.environment.tag.EditorTag;
import gui.environment.tag.PermanentTag;
import gui.environment.tag.Tag;
import gui.grammar.GrammarInputPane;
import gui.lsystem.LSystemInputPane;
import gui.pumping.CFPumpingLemmaChooser;
import gui.pumping.CompCFPumpingLemmaInputPane;
import gui.pumping.CompRegPumpingLemmaInputPane;
import gui.pumping.HumanCFPumpingLemmaInputPane;
import gui.pumping.HumanRegPumpingLemmaInputPane;
import gui.pumping.PumpingLemmaChooserPane;
import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.RegPumpingLemmaChooser;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JOptionPane;
import pumping.ContextFreePumpingLemma;
import pumping.RegularPumpingLemma;
import regular.RegularExpression;

public class EnvironmentFactory {
    private static final Tag EDITOR_PERMANENT_TAG = new EditorPermanentTag();
    private static final String EDITOR_NAME = "Editor";

    public static Environment getEnvironment(Serializable object) {
        if (object instanceof RegularPumpingLemma) {
            RegPumpingLemmaChooser plc = new RegPumpingLemmaChooser();
            PumpingLemmaEnvironment env = new PumpingLemmaEnvironment(plc);
            PumpingLemmaChooserPane pane = new PumpingLemmaChooserPane(plc, env);
            env.add((Component)pane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            RegularPumpingLemma pl = (RegularPumpingLemma)object;
            PumpingLemmaInputPane inputPane = pl.getFirstPlayer().equals("Computer") ? new CompRegPumpingLemmaInputPane(pl) : new HumanRegPumpingLemmaInputPane(pl);
            inputPane.update();
            plc.replace(pl);
            env.add((Component)inputPane, "Pumping Lemma", new CriticalTag(){});
            env.setActive(inputPane);
            return env;
        }
        if (object instanceof ContextFreePumpingLemma) {
            CFPumpingLemmaChooser plc = new CFPumpingLemmaChooser();
            PumpingLemmaEnvironment env = new PumpingLemmaEnvironment(plc);
            PumpingLemmaChooserPane pane = new PumpingLemmaChooserPane(plc, env);
            env.add((Component)pane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            ContextFreePumpingLemma pl = (ContextFreePumpingLemma)object;
            PumpingLemmaInputPane inputPane = pl.getFirstPlayer().equals("Computer") ? new CompCFPumpingLemmaInputPane(pl) : new HumanCFPumpingLemmaInputPane(pl);
            inputPane.update();
            plc.replace(pl);
            env.add((Component)inputPane, "Pumping Lemma", new CriticalTag(){});
            env.setActive(inputPane);
            return env;
        }
        if (object instanceof RegPumpingLemmaChooser) {
            RegPumpingLemmaChooser plc = (RegPumpingLemmaChooser)object;
            PumpingLemmaEnvironment env = new PumpingLemmaEnvironment(plc);
            PumpingLemmaChooserPane pane = new PumpingLemmaChooserPane(plc, env);
            env.add((Component)pane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof CFPumpingLemmaChooser) {
            CFPumpingLemmaChooser plc = (CFPumpingLemmaChooser)object;
            PumpingLemmaEnvironment env = new PumpingLemmaEnvironment(plc);
            PumpingLemmaChooserPane pane = new PumpingLemmaChooserPane(plc, env);
            env.add((Component)pane, "Select a Pumping Lemma", EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof MooreMachine) {
            Automaton aut = (Automaton)object;
            AutomatonEnvironment env = new AutomatonEnvironment(aut);
            EditorPane editor = new EditorPane(aut, (ToolBox)new MooreToolBox());
            env.add((Component)editor, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof MealyMachine) {
            Automaton aut = (Automaton)object;
            AutomatonEnvironment env = new AutomatonEnvironment(aut);
            EditorPane editor = new EditorPane(aut, (ToolBox)new MealyToolBox());
            env.add((Component)editor, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof Automaton) {
            Automaton aut = (Automaton)object;
            AutomatonEnvironment env = new AutomatonEnvironment(aut);
            EditorPane editor = new EditorPane(aut);
            env.add((Component)editor, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof Grammar) {
            if (object instanceof ConvertedUnrestrictedGrammar) {
                ConvertedUnrestrictedGrammar grammar = (ConvertedUnrestrictedGrammar)object;
                GrammarInputPane input = new GrammarInputPane(grammar);
                GrammarEnvironment env = new GrammarEnvironment(input);
                env.add((Component)input, EDITOR_NAME, EDITOR_PERMANENT_TAG);
                return env;
            }
            Grammar grammar = (Grammar)object;
            GrammarInputPane input = new GrammarInputPane(grammar);
            GrammarEnvironment env = new GrammarEnvironment(input);
            env.add((Component)input, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof RegularExpression) {
            RegularExpression re = (RegularExpression)object;
            gui.regular.EditorPane editor = new gui.regular.EditorPane(re);
            RegularEnvironment env = new RegularEnvironment(re);
            env.add((Component)editor, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        if (object instanceof LSystem) {
            LSystem lsystem = (LSystem)object;
            LSystemInputPane lsinput = new LSystemInputPane(lsystem);
            LSystemEnvironment env = new LSystemEnvironment(lsinput);
            env.add((Component)lsinput, EDITOR_NAME, EDITOR_PERMANENT_TAG);
            return env;
        }
        JOptionPane.showMessageDialog(null, "Unknown type " + object.getClass() + " read!", "Bad Type", 0);
        return null;
    }

    public static class EditorPermanentTag
    implements EditorTag,
    PermanentTag {
    }
}

