/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import automata.turing.TuringMachine;
import gui.environment.Universe;
import java.util.Deque;
import java.util.LinkedList;

public class UndoKeeper {
    private Automaton myMaster;
    private Deque<Automaton> myDeck;
    private Deque<Automaton> myBackDeck;
    private int numUndo;
    public boolean sensitive = false;
    private boolean wait = false;

    public UndoKeeper(Automaton master) {
        this.myMaster = master;
        this.myDeck = new LinkedList<Automaton>();
        this.myBackDeck = new LinkedList<Automaton>();
        this.numUndo = Universe.curProfile.undo_num;
    }

    public void setNumUndo(int nn) {
        this.numUndo = nn;
    }

    public void setWait() {
        this.wait = true;
    }

    public void saveStatus() {
        if (this.wait) {
            this.wait = false;
            return;
        }
        this.myDeck.push((Automaton)this.myMaster.clone());
        System.out.println();
        if (this.myDeck.size() >= 2) {
            Automaton first = this.myDeck.pop();
            Automaton second = this.myDeck.pop();
            if (first.hashCode() == second.hashCode()) {
                this.myDeck.push(first);
            } else {
                this.myDeck.push(second);
                this.myDeck.push(first);
                this.myBackDeck.clear();
            }
        }
        while (this.myDeck.size() > this.numUndo) {
            this.myDeck.removeLast();
        }
    }

    public void restoreStatus() {
        if (this.myDeck.size() == 0) {
            return;
        }
        Automaton p = null;
        while (this.myDeck.size() > 0 && (p = this.myDeck.pop()).hashCode() == this.myMaster.hashCode()) {
        }
        if (this.myDeck.size() == 0 && p.hashCode() == this.myMaster.hashCode()) {
            return;
        }
        this.sensitive = true;
        this.myBackDeck.push((Automaton)this.myMaster.clone());
        if (this.myMaster instanceof TuringMachine) {
            TuringMachine.become((TuringMachine)this.myMaster, (TuringMachine)p);
        } else {
            Automaton.become(this.myMaster, p);
        }
        this.sensitive = false;
        this.myMaster.getEnvironmentFrame().repaint();
    }

    public void redo() {
        if (this.myBackDeck.size() == 0) {
            return;
        }
        this.myDeck.push((Automaton)this.myMaster.clone());
        if (this.myMaster instanceof TuringMachine) {
            TuringMachine.become((TuringMachine)this.myMaster, (TuringMachine)this.myBackDeck.pop());
        } else {
            Automaton.become(this.myMaster, this.myBackDeck.pop());
        }
        this.myMaster.getEnvironmentFrame().repaint();
    }
}

