/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PDATransitionCreator
extends TableTransitionCreator {
    private static final String[] NAME = new String[]{"Read", "Pop", "Push"};

    public PDATransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    @Override
    protected Transition initTransition(State from, State to) {
        return new PDATransition(from, to, "", "", "");
    }

    @Override
    protected TableModel createModel(Transition transition) {
        PDATransition t = (PDATransition)transition;
        return new AbstractTableModel(t){
            private static final long serialVersionUID = 1L;
            String[] s;
            {
                this.s = new String[]{pDATransition.getInputToRead(), pDATransition.getStringToPop(), pDATransition.getStringToPush()};
            }

            @Override
            public Object getValueAt(int row, int column) {
                return this.s[column];
            }

            @Override
            public void setValueAt(Object o, int r, int c) {
                this.s[c] = (String)o;
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return true;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int c) {
                return NAME[c];
            }
        };
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel model) {
        String input = (String)model.getValueAt(0, 0);
        String pop = (String)model.getValueAt(0, 1);
        String push = (String)model.getValueAt(0, 2);
        PDATransition t = (PDATransition)transition;
        try {
            return new PDATransition(t.getFromState(), t.getToState(), input, pop, push);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

