/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.mealy.MooreTransition;
import gui.editor.MealyTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MooreTransitionCreator
extends MealyTransitionCreator {
    private static final String NAME = "Label";

    public MooreTransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    @Override
    protected Transition initTransition(State from, State to) {
        return new MooreTransition(from, to, "");
    }

    @Override
    protected TableModel createModel(Transition transition) {
        MooreTransition t = (MooreTransition)transition;
        return new AbstractTableModel(t){
            private static final long serialVersionUID = 1L;
            String[] s;
            {
                this.s = new String[]{mooreTransition.getLabel()};
            }

            @Override
            public Object getValueAt(int r, int c) {
                return this.s[c];
            }

            @Override
            public void setValueAt(Object o, int r, int c) {
                this.s[c] = (String)o;
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return true;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public String getColumnName(int c) {
                return MooreTransitionCreator.NAME;
            }
        };
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel model) {
        String label = (String)model.getValueAt(0, 0);
        MooreTransition t = (MooreTransition)transition;
        try {
            return new MooreTransition(t.getFromState(), t.getToState(), label);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

