/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.mealy.MealyTransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class MealyTransitionCreator
extends TableTransitionCreator {
    private static final String[] NAME = new String[]{"Label", "Output"};

    public MealyTransitionCreator(AutomatonPane parent) {
        super(parent);
    }

    @Override
    protected Transition initTransition(State from, State to) {
        return new MealyTransition(from, to, "", "");
    }

    @Override
    protected TableModel createModel(Transition transition) {
        MealyTransition t = (MealyTransition)transition;
        return new AbstractTableModel(t){
            private static final long serialVersionUID = 1L;
            String[] s;
            {
                this.s = new String[]{mealyTransition.getLabel(), mealyTransition.getOutput()};
            }

            @Override
            public Object getValueAt(int r, int c) {
                return this.s[c];
            }

            @Override
            public void setValueAt(Object o, int r, int c) {
                this.s[c] = (String)o;
            }

            @Override
            public boolean isCellEditable(int r, int c) {
                return true;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int c) {
                return NAME[c];
            }
        };
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel model) {
        String label = (String)model.getValueAt(0, 0);
        String output = (String)model.getValueAt(0, 1);
        MealyTransition t = (MealyTransition)transition;
        try {
            return new MealyTransition(t.getFromState(), t.getToState(), label, output);
        }
        catch (IllegalArgumentException e) {
            this.reportException(e);
            return null;
        }
    }
}

