/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.turing.TMState;
import automata.turing.TuringMachineBuildingBlocks;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class BuildingBlockTool
extends Tool {
    protected State first;
    protected Point hover;
    TMState block = null;

    public BuildingBlockTool(AutomatonPane view, AutomatonDrawer drawer, TransitionCreator creator) {
        super(view, drawer);
    }

    public BuildingBlockTool(AutomatonPane view, AutomatonDrawer drawer) {
        super(view, drawer);
    }

    @Override
    public String getToolTip() {
        return "Building Block Creator";
    }

    @Override
    protected Icon getIcon() {
        URL url = this.getClass().getResource("/ICON/blocks.gif");
        return new ImageIcon(url);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.block = ((TuringMachineBuildingBlocks)this.getAutomaton()).createBlock(event.getPoint());
        this.getView().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.first == null) {
            return;
        }
        this.hover = event.getPoint();
        this.getView().repaint();
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('b');
    }
}

